/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.ConcatKDF;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.util.Base64URL;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;

public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final SecureRandom randomGen;
    private final RSAPublicKey publicKey;

    public RSAEncrypter(RSAPublicKey publicKey) throws JOSEException {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
        try {
            this.randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public JWECryptoParts encrypt(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        SecretKey cmk = AES.generateAESCMK(enc.cmkBitLength());
        Base64URL encryptedKey = null;
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            encryptedKey = Base64URL.encode(RSA1_5.encryptCMK(this.publicKey, cmk));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            encryptedKey = Base64URL.encode(RSA_OAEP.encryptCMK(this.publicKey, cmk));
        } else {
            throw new JOSEException("Unsupported algorithm, must be RSA1_5 or RSA_OAEP");
        }
        if (encryptedKey == null) {
            throw new JOSEException("Couldn't generate encrypted key");
        }
        byte[] plainText = DeflateHelper.applyCompression(readOnlyJWEHeader, bytes);
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            byte[] epu = null;
            if (readOnlyJWEHeader.getEncryptionPartyUInfo() != null) {
                epu = readOnlyJWEHeader.getEncryptionPartyUInfo().decode();
            }
            byte[] epv = null;
            if (readOnlyJWEHeader.getEncryptionPartyVInfo() != null) {
                epv = readOnlyJWEHeader.getEncryptionPartyVInfo().decode();
            }
            SecretKey cek = ConcatKDF.generateCEK(cmk, enc, epu, epv);
            byte[] iv = AESCBC.generateIV(this.randomGen);
            byte[] cipherText = AESCBC.encrypt(cek, iv, plainText);
            SecretKey cik = ConcatKDF.generateCIK(cmk, enc, epu, epv);
            String macInput = readOnlyJWEHeader.toBase64URL().toString() + "." + encryptedKey.toString() + "." + Base64URL.encode(iv).toString() + "." + Base64URL.encode(cipherText);
            byte[] mac = HMAC.compute(cik, macInput.getBytes());
            return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(cipherText), Base64URL.encode(mac));
        }
        if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            byte[] authData;
            byte[] iv = AESGCM.generateIV(this.randomGen);
            String authDataString = readOnlyJWEHeader.toBase64URL().toString() + "." + encryptedKey.toString() + "." + Base64URL.encode(iv).toString();
            try {
                authData = authDataString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JOSEException(e.getMessage(), e);
            }
            AESGCM.Result result = AESGCM.encrypt(cmk, iv, plainText, authData);
            return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(result.getCipherText()), Base64URL.encode(result.getAuthenticationTag()));
        }
        throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
    }
}

