/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.AuthenticatedCipherText;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;

public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final SecureRandom randomGen;
    private final RSAPublicKey publicKey;

    public RSAEncrypter(RSAPublicKey publicKey) throws JOSEException {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
        try {
            this.randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public JWECryptoParts encrypt(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        SecretKey cek = AES.generateKey(enc.cekBitLength());
        Base64URL encryptedKey = null;
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            encryptedKey = Base64URL.encode(RSA1_5.encryptCEK(this.publicKey, cek));
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            encryptedKey = Base64URL.encode(RSA_OAEP.encryptCEK(this.publicKey, cek));
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be RSA1_5 or RSA-OAEP");
        }
        byte[] plainText = DeflateHelper.applyCompression(readOnlyJWEHeader, bytes);
        byte[] aad = StringUtils.toByteArray(readOnlyJWEHeader.toBase64URL() + "." + encryptedKey);
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(this.randomGen);
            authCipherText = AESCBC.encryptAuthenticated(cek, iv, plainText, aad);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(this.randomGen);
            authCipherText = AESGCM.encrypt(cek, iv, plainText, aad);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(authCipherText.getCipherText()), Base64URL.encode(authCipherText.getAuthenticationTag()));
    }
}

