/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.DefaultJWEHeaderFilter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.DirectCryptoProvider;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.StringUtils;
import javax.crypto.SecretKey;

public class DirectDecrypter
extends DirectCryptoProvider
implements JWEDecrypter {
    private final DefaultJWEHeaderFilter headerFilter = new DefaultJWEHeaderFilter(this.supportedAlgorithms(), this.supportedEncryptionMethods());

    public DirectDecrypter(SecretKey key) throws JOSEException {
        super(key);
    }

    public DirectDecrypter(byte[] keyBytes) throws JOSEException {
        super(keyBytes);
    }

    public JWEHeaderFilter getJWEHeaderFilter() {
        return this.headerFilter;
    }

    public byte[] decrypt(ReadOnlyJWEHeader readOnlyJWEHeader, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        byte[] plainText;
        if (encryptedKey != null) {
            throw new JOSEException("Unexpected encrypted key, must be omitted");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (authTag == null) {
            throw new JOSEException("The authentication tag must not be null");
        }
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException("Unsupported algorithm, must be \"dir\"");
        }
        byte[] aad = StringUtils.toByteArray(readOnlyJWEHeader.toBase64URL() + "." + encryptedKey);
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            plainText = AESCBC.decryptAuthenticated(this.getKey(), iv.decode(), cipherText.decode(), aad, authTag.decode());
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            plainText = AESGCM.decrypt(this.getKey(), iv.decode(), cipherText.decode(), aad, authTag.decode());
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return DeflateHelper.applyDecompression(readOnlyJWEHeader, plainText);
    }
}

