/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.AuthenticatedCipherText;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.DirectCryptoProvider;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    private static SecureRandom randomGen;

    private void initSecureRandom() throws JOSEException {
        try {
            randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public DirectEncrypter(SecretKey key) throws JOSEException {
        super(key);
        if (randomGen == null) {
            this.initSecureRandom();
        }
    }

    public DirectEncrypter(byte[] keyBytes) throws JOSEException {
        super(keyBytes);
        this.initSecureRandom();
    }

    public JWECryptoParts encrypt(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException("Unsupported JWE algorithm, must be \"dir\"");
        }
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.cekBitLength() != this.getKey().getEncoded().length * 8) {
            throw new JOSEException("The Content Encryption Key (CEK) length must be " + enc.cekBitLength() + " bits for " + enc + " encryption");
        }
        Base64URL encryptedKey = null;
        byte[] plainText = DeflateHelper.applyCompression(readOnlyJWEHeader, bytes);
        byte[] aad = StringUtils.toByteArray(readOnlyJWEHeader.toBase64URL() + "." + encryptedKey);
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(this.getKey(), iv, plainText, aad);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(this.getKey(), iv, plainText, aad);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(authCipherText.getCipherText()), Base64URL.encode(authCipherText.getAuthenticationTag()));
    }
}

