/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.util.DeflateUtils;

class DeflateHelper {
    DeflateHelper() {
    }

    public static byte[] applyCompression(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        CompressionAlgorithm compressionAlg = readOnlyJWEHeader.getCompressionAlgorithm();
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals(CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.compress(bytes);
            }
            catch (Exception e) {
                throw new JOSEException("Couldn't compress plain text: " + e.getMessage(), e);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlg);
    }

    public static byte[] applyDecompression(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        CompressionAlgorithm compressionAlg = readOnlyJWEHeader.getCompressionAlgorithm();
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals(CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.decompress(bytes);
            }
            catch (Exception e) {
                throw new JOSEException("Couldn't decompress plain text: " + e.getMessage(), e);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlg);
    }
}

