/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@Immutable
public final class KeyType
implements JSONAware {
    private final String value;
    private final Requirement requirement;
    public static final KeyType EC = new KeyType("EC", Requirement.RECOMMENDED);
    public static final KeyType RSA = new KeyType("RSA", Requirement.REQUIRED);

    public KeyType(String value, Requirement req) {
        if (value == null) {
            throw new IllegalArgumentException("The key type value must not be null");
        }
        this.value = value;
        this.requirement = req;
    }

    public String getValue() {
        return this.value;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof KeyType && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.value;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONObject.escape((String)this.value));
        sb.append('\"');
        return sb.toString();
    }

    public static KeyType parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("The ket type string must not be null");
        }
        if (s.equals(EC.getValue())) {
            return EC;
        }
        if (s.equals(RSA.getValue())) {
            return RSA;
        }
        return new KeyType(s, null);
    }
}

