/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.io.UnsupportedEncodingException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;
import org.apache.commons.codec.binary.Base64;

@Immutable
public class Base64URL
implements JSONAware {
    private static final String CHARSET = "utf-8";
    private final String value;

    public Base64URL(String base64URL) {
        if (base64URL == null) {
            throw new IllegalArgumentException("The Base64URL value must not be null");
        }
        this.value = base64URL;
    }

    public byte[] decode() {
        return Base64.decodeBase64((String)this.value);
    }

    public String decodeToString() {
        try {
            return new String(this.decode(), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String toJSONString() {
        return "\"" + JSONValue.escape((String)this.value) + "\"";
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Base64URL && this.toString().equals(object.toString());
    }

    public static Base64URL encode(String text) {
        try {
            return Base64URL.encode(text.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Base64URL encode(byte[] bytes) {
        return new Base64URL(Base64.encodeBase64URLSafeString((byte[])bytes));
    }
}

