/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTHandler;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import net.minidev.json.JSONObject;

public final class JWTParser {
    public static JWT parse(String s) throws ParseException {
        JSONObject jsonObject;
        int firstDotPos = s.indexOf(".");
        if (firstDotPos == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL header = new Base64URL(s.substring(0, firstDotPos));
        try {
            jsonObject = JSONObjectUtils.parseJSONObject(header.decodeToString());
        }
        catch (ParseException e) {
            throw new ParseException("Invalid plain/JWS/JWE header: " + e.getMessage(), 0);
        }
        Algorithm alg = Header.parseAlgorithm(jsonObject);
        if (alg.equals(Algorithm.NONE)) {
            return PlainJWT.parse(s);
        }
        if (alg instanceof JWSAlgorithm) {
            return SignedJWT.parse(s);
        }
        if (alg instanceof JWEAlgorithm) {
            return EncryptedJWT.parse(s);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + alg));
    }

    public static <T> T parse(String s, JWTHandler<T> handler) throws ParseException {
        JWT jwt = JWTParser.parse(s);
        if (jwt instanceof PlainJWT) {
            return handler.onPlainJWT((PlainJWT)jwt);
        }
        if (jwt instanceof SignedJWT) {
            return handler.onSignedJWT((SignedJWT)jwt);
        }
        return handler.onEncryptedJWT((EncryptedJWT)jwt);
    }

    private JWTParser() {
    }
}

