/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.proc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.PlainObject;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.BadJWEException;
import com.nimbusds.jose.proc.BadJWSException;
import com.nimbusds.jose.proc.BaseJOSEProcessor;
import com.nimbusds.jose.proc.JOSEProcessor;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJOSEProcessor<C extends SecurityContext>
extends BaseJOSEProcessor<C>
implements JOSEProcessor<Payload, C> {
    @Override
    public Payload process(String compactJOSE, C context) throws ParseException, BadJOSEException, JOSEException {
        JOSEObject joseObject = JOSEObject.parse(compactJOSE);
        if (joseObject instanceof JWSObject) {
            return this.process((JWSObject)joseObject, (SecurityContext)context);
        }
        if (joseObject instanceof JWEObject) {
            return this.process((JWEObject)joseObject, (SecurityContext)context);
        }
        if (joseObject instanceof PlainObject) {
            return this.process((PlainObject)joseObject, (SecurityContext)context);
        }
        throw new JOSEException("Unexpected JOSE object type: " + joseObject.getClass());
    }

    @Override
    public Payload process(PlainObject plainObject, C context) throws BadJOSEException {
        throw new BadJOSEException("Unsecured (plain) JOSE objects are rejected, extend class to handle");
    }

    @Override
    public Payload process(JWSObject jwsObject, C context) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw new BadJOSEException("JWS object rejected: No JWS key selector is configured");
        }
        if (this.getJWSVerifierFactory() == null) {
            throw new JOSEException("No JWS verifier is configured");
        }
        List<Key> keyCandidates = this.getJWSKeySelector().selectJWSKeys(jwsObject.getHeader(), context);
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw new BadJOSEException("JWS object rejected: No matching key(s) found");
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWSVerifier verifier = this.getJWSVerifierFactory().createJWSVerifier(jwsObject.getHeader(), it.next());
            if (verifier == null) continue;
            boolean validSignature = jwsObject.verify(verifier);
            if (validSignature) {
                return jwsObject.getPayload();
            }
            if (it.hasNext()) continue;
            throw new BadJWSException("JWS object rejected: Invalid signature");
        }
        throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    }

    @Override
    public Payload process(JWEObject jweObject, C context) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw new BadJOSEException("JWE object rejected: No JWE key selector is configured");
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw new JOSEException("No JWE decrypter is configured");
        }
        List<Key> keyCandidates = this.getJWEKeySelector().selectJWEKeys(jweObject.getHeader(), context);
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw new BadJOSEException("JWE object rejected: No matching key(s) found");
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWEDecrypter decrypter = this.getJWEDecrypterFactory().createJWEDecrypter(jweObject.getHeader(), it.next());
            if (decrypter == null) continue;
            try {
                jweObject.decrypt(decrypter);
            }
            catch (JOSEException e) {
                if (it.hasNext()) continue;
                throw new BadJWEException("JWE object rejected: " + e.getMessage(), e);
            }
            if ("JWT".equalsIgnoreCase(jweObject.getHeader().getContentType())) {
                JWSObject nestedJWS = jweObject.getPayload().toJWSObject();
                if (nestedJWS == null) {
                    return jweObject.getPayload();
                }
                return this.process(nestedJWS, (SecurityContext)context);
            }
            return jweObject.getPayload();
        }
        throw new BadJOSEException("JWE object rejected: No matching decrypter(s) found");
    }
}

