/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.source;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RemoteJWKSet<C extends SecurityContext>
implements JWKSource<C> {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 1000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 1000;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final URL jwkSetURL;
    private final AtomicReference<JWKSet> cachedJWKSet = new AtomicReference();
    private final AtomicReference<Exception> lastRetrievalException = new AtomicReference();
    private final ResourceRetriever jwkSetRetriever;

    public RemoteJWKSet(URL jwkSetURL) {
        this(jwkSetURL, null);
    }

    public RemoteJWKSet(URL jwkSetURL, ResourceRetriever resourceRetriever) {
        if (jwkSetURL == null) {
            throw new IllegalArgumentException("The JWK set URL must not be null");
        }
        this.jwkSetURL = jwkSetURL;
        this.jwkSetRetriever = resourceRetriever != null ? resourceRetriever : new DefaultResourceRetriever(1000, 1000, 51200);
    }

    private JWKSet updateJWKSetFromURL() {
        JWKSet jwkSet;
        try {
            Resource res = this.jwkSetRetriever.retrieveResource(this.jwkSetURL);
            jwkSet = JWKSet.parse(res.getContent());
        }
        catch (IOException | ParseException e) {
            this.lastRetrievalException.set(e);
            return null;
        }
        this.cachedJWKSet.set(jwkSet);
        return jwkSet;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.jwkSetRetriever;
    }

    public JWKSet getJWKSet() {
        JWKSet jwkSet = this.cachedJWKSet.get();
        if (jwkSet != null) {
            return jwkSet;
        }
        return this.updateJWKSetFromURL();
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jwkMatcher) {
        Set<String> keyIDs = jwkMatcher.getKeyIDs();
        if (keyIDs == null || keyIDs.isEmpty()) {
            return null;
        }
        for (String id : keyIDs) {
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public Exception getLastRetrievalException() {
        return this.lastRetrievalException.get();
    }

    @Override
    public List<JWK> get(JWKSelector jwkSelector, C context) {
        JWKSet jwkSet = this.getJWKSet();
        if (jwkSet == null) {
            return Collections.emptyList();
        }
        List<JWK> matches = jwkSelector.select(jwkSet);
        if (!matches.isEmpty()) {
            return matches;
        }
        String soughtKeyID = RemoteJWKSet.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
        if (soughtKeyID == null) {
            return matches;
        }
        if (jwkSet.getKeyByKeyId(soughtKeyID) != null) {
            return matches;
        }
        jwkSet = this.updateJWKSetFromURL();
        if (jwkSet == null) {
            return null;
        }
        return jwkSelector.select(jwkSet);
    }
}

