/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.proc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.PlainObject;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.BadJWEException;
import com.nimbusds.jose.proc.BadJWSException;
import com.nimbusds.jose.proc.ConfigurableJOSEProcessor;
import com.nimbusds.jose.proc.JWEDecrypterFactory;
import com.nimbusds.jose.proc.JWEKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jose.proc.SecurityContext;
import java.io.IOException;
import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJOSEProcessor<C extends SecurityContext>
implements ConfigurableJOSEProcessor<C> {
    private static final BadJOSEException PLAIN_JOSE_REJECTED_EXCEPTION = new BadJOSEException("Unsecured (plain) JOSE objects are rejected, extend class to handle");
    private static final BadJOSEException NO_JWS_KEY_SELECTOR_EXCEPTION = new BadJOSEException("JWS object rejected: No JWS key selector is configured");
    private static final BadJOSEException NO_JWE_KEY_SELECTOR_EXCEPTION = new BadJOSEException("JWE object rejected: No JWE key selector is configured");
    private static final JOSEException NO_JWS_VERIFIER_FACTORY_EXCEPTION = new JOSEException("No JWS verifier is configured");
    private static final JOSEException NO_JWE_DECRYPTER_FACTORY_EXCEPTION = new JOSEException("No JWE decrypter is configured");
    private static final BadJOSEException NO_JWS_KEY_CANDIDATES_EXCEPTION = new BadJOSEException("JWS object rejected: No matching key(s) found");
    private static final BadJOSEException NO_JWE_KEY_CANDIDATES_EXCEPTION = new BadJOSEException("JWE object rejected: No matching key(s) found");
    private static final BadJOSEException INVALID_SIGNATURE = new BadJWSException("JWS object rejected: Invalid signature");
    private static final BadJOSEException NO_MATCHING_VERIFIERS_EXCEPTION = new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    private static final BadJOSEException NO_MATCHING_DECRYPTERS_EXCEPTION = new BadJOSEException("JWE object rejected: No matching decrypter(s) found");
    private JWSKeySelector<C> jwsKeySelector;
    private JWEKeySelector<C> jweKeySelector;
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();

    @Override
    public JWSKeySelector<C> getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    @Override
    public void setJWSKeySelector(JWSKeySelector<C> jwsKeySelector) {
        this.jwsKeySelector = jwsKeySelector;
    }

    @Override
    public JWEKeySelector<C> getJWEKeySelector() {
        return this.jweKeySelector;
    }

    @Override
    public void setJWEKeySelector(JWEKeySelector<C> jweKeySelector) {
        this.jweKeySelector = jweKeySelector;
    }

    @Override
    public JWSVerifierFactory getJWSVerifierFactory() {
        return this.jwsVerifierFactory;
    }

    @Override
    public void setJWSVerifierFactory(JWSVerifierFactory factory) {
        this.jwsVerifierFactory = factory;
    }

    @Override
    public JWEDecrypterFactory getJWEDecrypterFactory() {
        return this.jweDecrypterFactory;
    }

    @Override
    public void setJWEDecrypterFactory(JWEDecrypterFactory factory) {
        this.jweDecrypterFactory = factory;
    }

    @Override
    public Payload process(String compactJOSE, C context) throws ParseException, BadJOSEException, JOSEException {
        return this.process(JOSEObject.parse(compactJOSE), context);
    }

    @Override
    public Payload process(JOSEObject joseObject, C context) throws BadJOSEException, JOSEException {
        if (joseObject instanceof JWSObject) {
            return this.process((JWSObject)joseObject, context);
        }
        if (joseObject instanceof JWEObject) {
            return this.process((JWEObject)joseObject, context);
        }
        if (joseObject instanceof PlainObject) {
            return this.process((PlainObject)joseObject, context);
        }
        throw new JOSEException("Unexpected JOSE object type: " + joseObject.getClass());
    }

    @Override
    public Payload process(PlainObject plainObject, C context) throws BadJOSEException {
        throw PLAIN_JOSE_REJECTED_EXCEPTION;
    }

    @Override
    public Payload process(JWSObject jwsObject, C context) throws BadJOSEException, JOSEException {
        List<Key> keyCandidates;
        if (this.getJWSKeySelector() == null) {
            throw NO_JWS_KEY_SELECTOR_EXCEPTION;
        }
        if (this.getJWSVerifierFactory() == null) {
            throw NO_JWS_VERIFIER_FACTORY_EXCEPTION;
        }
        try {
            keyCandidates = this.getJWSKeySelector().selectJWSKeys(jwsObject.getHeader(), context);
        }
        catch (IOException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw NO_JWS_KEY_CANDIDATES_EXCEPTION;
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWSVerifier verifier = this.getJWSVerifierFactory().createJWSVerifier(jwsObject.getHeader(), it.next());
            if (verifier == null) continue;
            boolean validSignature = jwsObject.verify(verifier);
            if (validSignature) {
                return jwsObject.getPayload();
            }
            if (it.hasNext()) continue;
            throw INVALID_SIGNATURE;
        }
        throw NO_MATCHING_VERIFIERS_EXCEPTION;
    }

    @Override
    public Payload process(JWEObject jweObject, C context) throws BadJOSEException, JOSEException {
        List<Key> keyCandidates;
        if (this.getJWEKeySelector() == null) {
            throw NO_JWE_KEY_SELECTOR_EXCEPTION;
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw NO_JWE_DECRYPTER_FACTORY_EXCEPTION;
        }
        try {
            keyCandidates = this.getJWEKeySelector().selectJWEKeys(jweObject.getHeader(), context);
        }
        catch (IOException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw NO_JWE_KEY_CANDIDATES_EXCEPTION;
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWEDecrypter decrypter = this.getJWEDecrypterFactory().createJWEDecrypter(jweObject.getHeader(), it.next());
            if (decrypter == null) continue;
            try {
                jweObject.decrypt(decrypter);
            }
            catch (JOSEException e) {
                if (it.hasNext()) continue;
                throw new BadJWEException("JWE object rejected: " + e.getMessage(), e);
            }
            if ("JWT".equalsIgnoreCase(jweObject.getHeader().getContentType())) {
                JWSObject nestedJWS = jweObject.getPayload().toJWSObject();
                if (nestedJWS == null) {
                    return jweObject.getPayload();
                }
                return this.process(nestedJWS, context);
            }
            return jweObject.getPayload();
        }
        throw NO_MATCHING_DECRYPTERS_EXCEPTION;
    }
}

