/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.loader.FileInputStreamSource;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.Logger;

@Immutable
class JOSEConfiguration {
    static final String FILENAME = "/WEB-INF/jose.properties";
    private final boolean allowWeakKeys;
    private final boolean pkcs11Enabled;
    private final String pkcs11ConfigFile;
    private final char[] pkcs11KeyStorePassword;
    private final List<String> pkcs11KeyIDs;

    public JOSEConfiguration() {
        this(new Properties());
    }

    public JOSEConfiguration(Properties props) {
        this(props, false);
    }

    public JOSEConfiguration(Properties props, boolean override) {
        PropertyRetriever pr = new PropertyRetriever(props, override);
        try {
            this.allowWeakKeys = pr.getOptBoolean("jose.allowWeakKeys", false);
            this.pkcs11Enabled = pr.getOptBoolean("pkcs11.enable", false);
            if (this.pkcs11Enabled) {
                this.pkcs11ConfigFile = pr.getOptString("pkcs11.configFile", null);
                if (this.pkcs11ConfigFile == null || this.pkcs11ConfigFile.trim().isEmpty()) {
                    throw new RuntimeException("PKCS#11 is enabled by pkcs11.enable, but no PKCS#11 configuration is specified in pkcs11.configFile");
                }
                String pw = pr.getOptString("pkcs11.password", null);
                this.pkcs11KeyStorePassword = pw == null || pw.trim().isEmpty() ? "".toCharArray() : pw.trim().toCharArray();
                this.pkcs11KeyIDs = pr.getOptStringListMulti("pkcs11.keyIDs.", Collections.emptyList());
            } else {
                this.pkcs11ConfigFile = null;
                this.pkcs11KeyStorePassword = "".toCharArray();
                this.pkcs11KeyIDs = Collections.emptyList();
            }
        }
        catch (PropertyParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    boolean isAllowWeakKeys() {
        return this.allowWeakKeys;
    }

    boolean isPKCS11Enabled() {
        return this.pkcs11Enabled;
    }

    String getPKCS11ConfigurationFile() {
        return this.pkcs11ConfigFile;
    }

    char[] getPKCS11KeyStorePassword() {
        return this.pkcs11KeyStorePassword;
    }

    boolean hasPKCS11KeyStorePassword() {
        return this.getPKCS11KeyStorePassword().length > 0;
    }

    public List<String> getPKCS11KeyIDs() {
        return this.pkcs11KeyIDs;
    }

    void log(Logger logger) {
        if (logger == null) {
            return;
        }
        logger.info("[SE0000] JOSE configuration: Allow weak RSA keys: {}", (Object)this.isAllowWeakKeys());
        logger.info("[SE0001] JOSE configuration: PKCS#11 enabled: {}", (Object)this.isPKCS11Enabled());
        if (this.isPKCS11Enabled()) {
            logger.info("[SE0002] JOSE configuration: PKCS#11 configuration file: {}", (Object)this.getPKCS11ConfigurationFile());
            logger.info("[SE0003] JOSE configuration: PKCS#11 password configured: {}", (Object)this.hasPKCS11KeyStorePassword());
            logger.info("[SE0004] JOSE configuration: PKCS#11 key IDs to load: {}", this.getPKCS11KeyIDs().isEmpty() ? "all" : this.getPKCS11KeyIDs());
        }
    }

    static JOSEConfiguration load(FileInputStreamSource fisSource) throws IOException {
        InputStream is = fisSource.getInputSteam(FILENAME);
        Properties properties = new Properties();
        if (is != null) {
            properties.load(is);
        }
        return new JOSEConfiguration(properties, true);
    }
}

