/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.loader.Loggers;
import com.nimbusds.jose.jwk.loader.PKCS11Utils;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.X509CertUtils;
import java.security.cert.X509Certificate;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class JWKMetaLogger {
    public static void log(JWKSet jwkSet) {
        Loggers.MAIN_LOG.info("[SE1008] JWK set:");
        for (int i = 0; i < jwkSet.getKeys().size(); ++i) {
            JWKMetaLogger.log(i + 1, (JWK)jwkSet.getKeys().get(i));
        }
    }

    private static void log(int pos, JWK jwk) {
        Base64URL thumbprint;
        byte[] derCert;
        X509Certificate cert;
        boolean x509CertPresent;
        if (jwk == null) {
            return;
        }
        String isPrivate = "";
        if (jwk instanceof AsymmetricJWK) {
            isPrivate = jwk.isPrivate() ? " private=true" : " private=false";
        }
        Object validityTimeWindow = "";
        boolean bl = x509CertPresent = jwk.getX509CertChain() != null && !jwk.getX509CertChain().isEmpty() && jwk.getX509CertChain().get(0) != null;
        if (x509CertPresent && (cert = X509CertUtils.parse((byte[])(derCert = ((Base64)jwk.getX509CertChain().get(0)).decode()))) != null) {
            Date exp;
            Date nbf = cert.getNotBefore();
            if (nbf != null) {
                validityTimeWindow = "nbf=" + DateTimeFormatter.ISO_INSTANT.format(nbf.toInstant());
            }
            if ((exp = cert.getNotAfter()) != null) {
                validityTimeWindow = (String)validityTimeWindow + " exp=" + DateTimeFormatter.ISO_INSTANT.format(exp.toInstant());
            }
        }
        try {
            thumbprint = jwk.computeThumbprint();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
        Loggers.MAIN_LOG.info("[SE3000] [{}] JWK type={} id={}{} use={} size={} x5c={} pkcs#11={} thumbprint={} {}", (Object)pos, (Object)jwk.getKeyType(), (Object)jwk.getKeyID(), (Object)isPrivate, (Object)jwk.getKeyUse(), (Object)jwk.size(), (Object)x509CertPresent, (Object)PKCS11Utils.isPKCS11Key(jwk), (Object)thumbprint, validityTimeWindow);
    }

    private JWKMetaLogger() {
    }
}

