/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.jwk.loader.FileInputStreamSource;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.Logger;

@Immutable
public class PKCS11Configuration {
    static final String DEFAULT_CONFIG_FILENAME = "/WEB-INF/jose.properties";
    static final String DEFAULT_CONFIG_PROPERTY_PREFIX = "pkcs11.";
    private final boolean pkcs11Enabled;
    private final String pkcs11ConfigFile;
    private final char[] pkcs11KeyStorePassword;
    private final List<String> pkcs11KeyIDs;

    public PKCS11Configuration() {
        this(new Properties());
    }

    public PKCS11Configuration(Properties props) {
        this(props, false);
    }

    public PKCS11Configuration(Properties props, boolean override) {
        this(DEFAULT_CONFIG_PROPERTY_PREFIX, props, override);
    }

    public PKCS11Configuration(String prefix, Properties props, boolean override) {
        PropertyRetriever pr = new PropertyRetriever(props, override);
        try {
            this.pkcs11Enabled = pr.getOptBoolean(prefix + "enable", false);
            if (this.pkcs11Enabled) {
                this.pkcs11ConfigFile = pr.getOptString(prefix + "configFile", null);
                if (this.pkcs11ConfigFile == null || this.pkcs11ConfigFile.trim().isEmpty()) {
                    throw new RuntimeException("PKCS#11 is enabled by pkcs11.enable, but no PKCS#11 configuration is specified in " + prefix + "configFile");
                }
                String pw = pr.getOptString(prefix + "password", null);
                this.pkcs11KeyStorePassword = pw == null || pw.trim().isEmpty() ? "".toCharArray() : pw.trim().toCharArray();
                this.pkcs11KeyIDs = pr.getOptStringListMulti(prefix + "keyIDs.", Collections.emptyList());
            } else {
                this.pkcs11ConfigFile = null;
                this.pkcs11KeyStorePassword = "".toCharArray();
                this.pkcs11KeyIDs = Collections.emptyList();
            }
        }
        catch (PropertyParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isPKCS11Enabled() {
        return this.pkcs11Enabled;
    }

    public String getPKCS11ConfigurationFile() {
        return this.pkcs11ConfigFile;
    }

    public char[] getPKCS11KeyStorePassword() {
        return this.pkcs11KeyStorePassword;
    }

    public boolean hasPKCS11KeyStorePassword() {
        return this.getPKCS11KeyStorePassword().length > 0;
    }

    public List<String> getPKCS11KeyIDs() {
        return this.pkcs11KeyIDs;
    }

    public void log(Logger logger) {
        if (logger == null) {
            return;
        }
        logger.info("[SE0001] PKCS#11 enabled: {}", (Object)this.isPKCS11Enabled());
        if (this.isPKCS11Enabled()) {
            logger.info("[SE0002] PKCS#11 configuration file: {}", (Object)this.getPKCS11ConfigurationFile());
            logger.info("[SE0003] PKCS#11 password configured: {}", (Object)this.hasPKCS11KeyStorePassword());
            logger.info("[SE0004] PKCS#11 key IDs to load: {}", this.getPKCS11KeyIDs().isEmpty() ? "all" : this.getPKCS11KeyIDs());
        }
    }

    static PKCS11Configuration load(FileInputStreamSource fisSource) throws IOException {
        InputStream is = fisSource.getInputSteam(DEFAULT_CONFIG_FILENAME);
        Properties properties = new Properties();
        if (is != null) {
            properties.load(is);
        }
        return new PKCS11Configuration(properties, true);
    }
}

