/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk.loader;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.loader.Loggers;
import java.util.LinkedList;
import java.util.List;

public class WeakRSAKeyDetector {
    public static List<String> findWeakRSAKeys(JWKSet jwkSet) {
        LinkedList<String> idsOfWeakKeys = new LinkedList<String>();
        jwkSet.getKeys().forEach(jwk -> {
            RSAKey rsaJWK;
            if (jwk instanceof RSAKey && (rsaJWK = (RSAKey)jwk).size() < 2048) {
                idsOfWeakKeys.add(rsaJWK.getKeyID());
            }
        });
        return idsOfWeakKeys;
    }

    public static void ensureNoWeakRSAKeys(JWKSet jwkSet) throws JOSEException {
        List<String> idsOfWeakKeys = WeakRSAKeyDetector.findWeakRSAKeys(jwkSet);
        if (idsOfWeakKeys.isEmpty()) {
            return;
        }
        String msg = "Found weak RSA key(s) shorter than 2048 bits with IDs: " + idsOfWeakKeys;
        Loggers.MAIN_LOG.error("[SE1030] {}", (Object)msg);
        throw new JOSEException(msg);
    }
}

