/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.common;

import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.token.TokenEncoding;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class AccessTokenConfig {
    public final long lifetime;
    public final TokenEncoding encoding;
    public final Optional<Boolean> encrypt;
    public final List<Audience> audienceList;
    public final Set<String> includeClientMetadataFields;

    public AccessTokenConfig(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props, true);
        this.lifetime = pr.getOptLong(prefix + "accessToken.lifetime", 0L);
        this.encoding = (TokenEncoding)pr.getOptEnum(prefix + "accessToken.encoding", TokenEncoding.class, (Enum)TokenEncoding.SELF_CONTAINED);
        this.encrypt = this.encoding.equals((Object)TokenEncoding.SELF_CONTAINED) ? pr.getOptBoolean(prefix + "accessToken.encrypt", Optional.empty()) : Optional.empty();
        this.audienceList = Audience.create((List)pr.getOptStringList(prefix + "accessToken.audienceList", null));
        this.includeClientMetadataFields = new HashSet<String>(pr.getOptStringList(prefix + "accessToken.includeClientMetadataFields", Collections.emptyList()));
    }

    public void log(String logPrefix) {
        Loggers.MAIN.info("[" + logPrefix + "0101] Access token lifetime: {}", this.lifetime > 0L ? Long.valueOf(this.lifetime) : "default");
        Loggers.MAIN.info("[" + logPrefix + "0102] Access token encoding: {}", (Object)this.encoding);
        if (this.encoding.equals((Object)TokenEncoding.SELF_CONTAINED)) {
            Loggers.MAIN.info("[" + logPrefix + "0103] Access JWT encrypt: {}", this.encrypt.isPresent() ? this.encrypt.get() : "default");
        }
        Loggers.MAIN.info("[" + logPrefix + "0104] Access token audience: {}", this.audienceList);
        Loggers.MAIN.info("[" + logPrefix + "0105] Client metadata fields to include in access tokens: {}", this.includeClientMetadataFields);
    }
}

