/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.common;

import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class ClientMetadataFilter {
    public static final int MAX_PATH_DEPTH = 2;
    private final Set<List<String>> paths;

    public ClientMetadataFilter(Set<String> fieldIncludeSpecs) {
        HashSet modPaths = new HashSet();
        fieldIncludeSpecs.forEach(spec -> {
            List<String> path = ClientMetadataFilter.parsePath(spec);
            if (path.size() > 2) {
                throw new IllegalArgumentException("The maximum allowed field depth is 2");
            }
            modPaths.add(path);
        });
        this.paths = Collections.unmodifiableSet(modPaths);
    }

    public static List<String> parsePath(String pathSpec) {
        return Arrays.asList(pathSpec.split("\\."));
    }

    public Set<List<String>> getFieldPaths() {
        return this.paths;
    }

    public JSONObject filter(ClientMetadata clientMetadata) {
        if (this.getFieldPaths().isEmpty()) {
            return null;
        }
        JSONObject in = clientMetadata.toJSONObject();
        JSONObject out = new JSONObject();
        for (List<String> path : this.getFieldPaths()) {
            String fieldName;
            JSONObject topLevelJSONObject;
            Object value;
            Object topLevelValue;
            if (path.size() == 1) {
                String fieldName2 = path.get(0);
                Object value2 = in.get((Object)fieldName2);
                if (value2 == null) continue;
                out.put((Object)fieldName2, value2);
                continue;
            }
            if (path.size() != 2 || !((topLevelValue = in.get((Object)path.get(0))) instanceof JSONObject) || (value = (topLevelJSONObject = (JSONObject)topLevelValue).get((Object)(fieldName = path.get(1)))) == null) continue;
            out.put((Object)fieldName, value);
        }
        if (MapUtils.isEmpty((Map)out)) {
            return null;
        }
        return out;
    }
}

