/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.common;

import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Optional;
import java.util.Properties;
import net.jcip.annotations.Immutable;

@Immutable
public final class RefreshTokenConfig {
    public final boolean issue;
    public final long lifetime;
    public final long maxIdleTime;
    public final Optional<Boolean> rotate;

    public RefreshTokenConfig(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props, true);
        this.issue = pr.getOptBoolean(prefix + "refreshToken.issue", true);
        this.lifetime = pr.getOptLong(prefix + "refreshToken.lifetime", -1L);
        this.maxIdleTime = pr.getOptLong(prefix + "refreshToken.maxIdleTime", 0L);
        this.rotate = pr.getOptBoolean(prefix + "refreshToken.rotate", Optional.empty());
    }

    public void log(String logPrefix) {
        Loggers.MAIN.info("[" + logPrefix + "0106] Refresh token issue: {}", (Object)this.issue);
        if (!this.issue) {
            return;
        }
        Loggers.MAIN.info("[" + logPrefix + "0107] Refresh token lifetime: {}", this.lifetime > -1L ? Long.valueOf(this.lifetime) : "default");
        Loggers.MAIN.info("[" + logPrefix + "0108] Refresh token max idle time: {}", (Object)this.maxIdleTime);
        Loggers.MAIN.info("[" + logPrefix + "0109] Refresh token rotate: {}", this.rotate.isPresent() ? this.rotate.get() : "default");
    }
}

