/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.common;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ScopeUtils {
    public static Scope resolveAuthorizedScope(@Nullable Scope requestedScope, @Nullable Scope clientRegisteredScope) throws GeneralException {
        if (CollectionUtils.isEmpty((Collection)clientRegisteredScope)) {
            throw new GeneralException("Access denied", OAuth2Error.INVALID_SCOPE.setDescription("Access denied"));
        }
        if (CollectionUtils.isEmpty((Collection)requestedScope)) {
            return clientRegisteredScope;
        }
        Scope authorizedScope = new Scope(requestedScope);
        authorizedScope.retainAll((Collection)clientRegisteredScope);
        if (authorizedScope.isEmpty()) {
            throw new GeneralException("Access denied", OAuth2Error.INVALID_SCOPE.setDescription("Access denied"));
        }
        return authorizedScope;
    }

    private ScopeUtils() {
    }
}

