/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.provider.spi.InitContext;
import com.nimbusds.openid.connect.provider.spi.grants.GrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.BaseGrantHandlerConfiguration;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class BaseGrantHandler
implements GrantHandler {
    private final String configFilePath;
    protected BaseGrantHandlerConfiguration config;

    public BaseGrantHandler(String configFilePath) {
        this.configFilePath = Objects.requireNonNull(configFilePath);
    }

    public abstract <T extends BaseGrantHandlerConfiguration> T loadConfiguration(Properties var1);

    public void init(InitContext initContext) throws Exception {
        Properties props = new Properties();
        InputStream inputStream = initContext.getResourceAsStream(this.configFilePath);
        if (inputStream != null) {
            props.load(inputStream);
        }
        this.config = this.loadConfiguration(props);
        this.config.log();
    }

    public BaseGrantHandlerConfiguration getConfiguration() {
        return this.config;
    }

    public boolean isEnabled() {
        return this.config.enable;
    }

    protected void ensureEnabled() throws GeneralException {
        if (!this.config.enable) {
            throw new GeneralException("Grant handler disabled", OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        }
    }

    protected void logTokenRequest(TokenRequestParameters tokenRequestParams, ClientID clientID) {
        Loggers.TOKEN.debug("[{}0002] {}} grant handler: Received request: client_id={} scope={}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)clientID, (Object)tokenRequestParams.getScope());
    }

    public void shutdown() {
        Loggers.MAIN.info("[{}0014] Shutting down {} grant handler...", (Object)this.config.logPrefix, (Object)this.config.grantShortName);
    }
}

