/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Objects;
import java.util.Properties;

public abstract class BaseGrantHandlerConfiguration
implements LoggableConfiguration {
    public final String grantShortName;
    public final String logPrefix;
    public final boolean enable;

    protected BaseGrantHandlerConfiguration(String prefix, Properties props, String grantShortName, String logPrefix) throws ConfigurationException {
        Objects.requireNonNull(prefix);
        this.grantShortName = Objects.requireNonNull(grantShortName);
        this.logPrefix = Objects.requireNonNull(logPrefix);
        PropertyRetriever pr = new PropertyRetriever(props, true);
        try {
            this.enable = pr.getOptBoolean(prefix + "enable", false);
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey(), (Throwable)e);
        }
    }

    public void log() {
        Loggers.MAIN.info("[" + this.logPrefix + "0000] " + this.grantShortName + " grant handler enabled: {}", (Object)this.enable);
    }
}

