/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.local.clientcredentials;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.provider.spi.grants.AccessTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.ClientCredentialsGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.GrantAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.GrantHandlerContext;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.ClientMetadataFilter;
import com.nimbusds.openid.connect.provider.spi.impl.common.ScopeUtils;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.BaseGrantHandler;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.local.clientcredentials.Configuration;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SimpleClientCredentialsGrantHandler
extends BaseGrantHandler
implements ClientCredentialsGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/clientGrantHandler.properties";

    public SimpleClientCredentialsGrantHandler() {
        super(CONFIG_FILE_PATH);
    }

    public Configuration loadConfiguration(Properties props) {
        return new Configuration(props);
    }

    @Override
    public Configuration getConfiguration() {
        return (Configuration)this.config;
    }

    public GrantType getGrantType() {
        return GrantType.CLIENT_CREDENTIALS;
    }

    public GrantAuthorization processGrant(TokenRequestParameters tokenRequestParams, ClientID clientID, ClientMetadata clientMetadata, GrantHandlerContext handlerCtx) throws GeneralException {
        this.ensureEnabled();
        this.logTokenRequest(tokenRequestParams, clientID);
        Scope authorizedScope = ScopeUtils.resolveAuthorizedScope(tokenRequestParams.getScope(), clientMetadata.getScope());
        assert (this.getConfiguration().accessToken != null);
        return new GrantAuthorization(authorizedScope, new AccessTokenSpec(this.getConfiguration().accessToken.lifetime, this.getConfiguration().accessToken.audienceList, this.getConfiguration().accessToken.encoding, this.getConfiguration().accessToken.encrypt), new ClientMetadataFilter(this.getConfiguration().accessToken.includeClientMetadataFields).filter(clientMetadata));
    }
}

