/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.local.jwt.selfissued;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.provider.spi.grants.AccessTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.ClaimsSpec;
import com.nimbusds.openid.connect.provider.spi.grants.GrantHandlerContext;
import com.nimbusds.openid.connect.provider.spi.grants.IDTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.SelfIssuedAssertionAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.SelfIssuedJWTGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.ClientMetadataFilter;
import com.nimbusds.openid.connect.provider.spi.impl.common.ScopeUtils;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.BaseGrantHandler;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.local.jwt.selfissued.Configuration;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SimpleSelfIssuedJWTGrantHandler
extends BaseGrantHandler
implements SelfIssuedJWTGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/selfIssuedJWTBearerHandler.properties";

    public SimpleSelfIssuedJWTGrantHandler() {
        super(CONFIG_FILE_PATH);
    }

    public Configuration loadConfiguration(Properties props) {
        return new Configuration(props);
    }

    @Override
    public Configuration getConfiguration() {
        return (Configuration)this.config;
    }

    public GrantType getGrantType() {
        return GrantType.JWT_BEARER;
    }

    public SelfIssuedAssertionAuthorization processSelfIssuedGrant(JWTClaimsSet jwtClaimsSet, TokenRequestParameters tokenRequestParams, ClientID clientID, OIDCClientMetadata clientMetadata, GrantHandlerContext handlerCtx) throws GeneralException {
        this.ensureEnabled();
        this.logTokenRequest(tokenRequestParams, clientID);
        Scope authorizedScope = ScopeUtils.resolveAuthorizedScope(tokenRequestParams.getScope(), clientMetadata.getScope());
        assert (this.getConfiguration().accessToken != null);
        return new SelfIssuedAssertionAuthorization(new Subject(jwtClaimsSet.getSubject()), authorizedScope, new AccessTokenSpec(this.getConfiguration().accessToken.lifetime, this.getConfiguration().accessToken.audienceList, this.getConfiguration().accessToken.encoding, this.getConfiguration().accessToken.encrypt), IDTokenSpec.NONE, new ClaimsSpec(handlerCtx.resolveClaimNames(authorizedScope)), new ClientMetadataFilter(this.getConfiguration().accessToken.includeClientMetadataFields).filter((ClientMetadata)clientMetadata));
    }
}

