/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.BaseGrantHandler;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseWebConfiguration;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.WebHandlerRequest;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public abstract class BaseGrantDelegator
extends BaseGrantHandler {
    public BaseGrantDelegator(String configFilePath) {
        super(configFilePath);
    }

    @Override
    public BaseWebConfiguration getConfiguration() {
        return (BaseWebConfiguration)this.config;
    }

    protected JSONObject send(WebHandlerRequest handlerRequest) throws GeneralException {
        HTTPResponse httpResponse;
        this.ensureEnabled();
        HTTPRequest httpRequest = handlerRequest.toHTTPRequest(this.getConfiguration().connectTimeout, this.getConfiguration().readTimeout);
        Loggers.TOKEN.debug("[{}0007] {} grant handler: New HTTP POST to {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)httpRequest.getURL());
        try {
            httpResponse = httpRequest.send();
        }
        catch (IOException e) {
            Loggers.TOKEN.error("[{}0008] {} grant handler: HTTP exception: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage(), (Object)e);
            throw new GeneralException(OAuth2Error.SERVER_ERROR);
        }
        if (!httpResponse.indicatesSuccess()) {
            ErrorObject errorObject = this.processNon200Response(httpResponse);
            throw new GeneralException(errorObject.getCode(), errorObject);
        }
        Loggers.TOKEN.debug("[{}0009] {} grant handler: Received authorization response: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)httpResponse.getBody());
        try {
            return httpResponse.getBodyAsJSONObject();
        }
        catch (Exception e) {
            Loggers.TOKEN.error("[{}0010] {} grant handler: Invalid authorization response: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage(), (Object)e);
            throw new GeneralException(OAuth2Error.SERVER_ERROR);
        }
    }

    public ErrorObject processNon200Response(HTTPResponse httpResponse) {
        if (httpResponse.getStatusCode() != 400) {
            Loggers.TOKEN.error("[{}0011] {} handler: Unexpected HTTP response: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)httpResponse.getStatusCode());
            return OAuth2Error.SERVER_ERROR;
        }
        ErrorObject errorObject = ErrorObject.parse((HTTPResponse)httpResponse);
        if (errorObject.getCode() == null) {
            Loggers.TOKEN.error("[{}0012] {} grant handler: Missing OAuth 2.0 error code: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)errorObject.getCode());
            return OAuth2Error.SERVER_ERROR;
        }
        Loggers.TOKEN.info("[{}0013] {} grant handler: Token request denied: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)errorObject.getCode());
        return errorObject;
    }

    public TokenRequestParameters keepAllowedCustomParams(final TokenRequestParameters params) {
        return new TokenRequestParameters(){

            public Scope getScope() {
                return params.getScope();
            }

            public List<URI> getResources() {
                return params.getResources();
            }

            public Map<String, List<String>> getCustomParameters() {
                if (BaseGrantDelegator.this.getConfiguration().customParams.isEmpty() || params.getCustomParameters() == null) {
                    return Collections.emptyMap();
                }
                HashMap<String, List> filtered = new HashMap<String, List>();
                for (Map.Entry en : params.getCustomParameters().entrySet()) {
                    if (!BaseGrantDelegator.this.getConfiguration().customParams.contains(en.getKey())) continue;
                    filtered.put((String)en.getKey(), (List)en.getValue());
                }
                return Collections.unmodifiableMap(filtered);
            }
        };
    }
}

