/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.BaseGrantHandlerConfiguration;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;

public abstract class BaseWebConfiguration
extends BaseGrantHandlerConfiguration {
    public final URL url;
    public final BearerAccessToken apiAccessToken;
    public final Set<String> customParams;
    public static final Set<String> DEFAULT_CLIENT_METADATA = Set.of("scope", "application_type", "sector_identifier_uri", "subject_type", "default_max_age", "require_auth_time", "default_acr_values", "data");
    public final Set<String> clientMetadata;
    public final int connectTimeout;
    public final int readTimeout;

    protected BaseWebConfiguration(String prefix, Properties props, String grantShortName, String logPrefix) throws ConfigurationException {
        super(prefix, props, grantShortName, logPrefix);
        PropertyRetriever pr = new PropertyRetriever(props, true);
        try {
            if (!this.enable) {
                this.url = null;
                this.apiAccessToken = null;
                this.customParams = Collections.emptySet();
                this.clientMetadata = Collections.emptySet();
                this.connectTimeout = 0;
                this.readTimeout = 0;
                return;
            }
            this.url = pr.getURL(prefix + "url");
            this.apiAccessToken = new BearerAccessToken(pr.getString(prefix + "apiAccessToken"));
            this.customParams = Set.copyOf(pr.getOptStringList(prefix + "customParams", Collections.emptyList()));
            this.clientMetadata = Set.copyOf(pr.getOptStringList(prefix + "clientMetadata", new LinkedList<String>(DEFAULT_CLIENT_METADATA)));
            this.connectTimeout = pr.getOptInt(prefix + "connectTimeout", 0);
            this.readTimeout = pr.getOptInt(prefix + "readTimeout", 0);
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey(), (Throwable)e);
        }
    }

    @Override
    public void log() {
        super.log();
        if (!this.enable) {
            return;
        }
        Loggers.MAIN.info("[" + this.logPrefix + "0001] " + this.grantShortName + " grant handler: Endpoint URL: {}", (Object)this.url);
        Loggers.MAIN.info("[" + this.logPrefix + "0002] " + this.grantShortName + " grant handler: Accepted custom token request parameters: {}", this.customParams);
        Loggers.MAIN.info("[" + this.logPrefix + "0005] " + this.grantShortName + " grant handler: Included client metadata parameters: {}", this.clientMetadata);
        Loggers.MAIN.info("[" + this.logPrefix + "0003] " + this.grantShortName + " grant handler: HTTP connect timeout: {} ms", (Object)this.connectTimeout);
        Loggers.MAIN.info("[" + this.logPrefix + "0004] " + this.grantShortName + " grant handler: HTTP read timeout: {} ms", (Object)this.readTimeout);
    }
}

