/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.WebHandlerRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minidev.json.JSONObject;

public class BaseWebHandlerRequest
implements WebHandlerRequest {
    private final Issuer issuer;
    private final URL url;
    private final BearerAccessToken accessToken;
    private final TokenRequestParameters tokenRequestParams;
    private final ClientID clientID;
    private final Optional<Boolean> confidentialClient;
    private final JSONObject clientMetadata;

    public BaseWebHandlerRequest(Issuer issuer, URL url, BearerAccessToken accessToken, TokenRequestParameters tokenRequestParams, ClientID clientID, Optional<Boolean> confidentialClient, JSONObject clientMetadata) {
        this.issuer = Objects.requireNonNull(issuer);
        this.url = Objects.requireNonNull(url);
        this.accessToken = Objects.requireNonNull(accessToken);
        this.tokenRequestParams = Objects.requireNonNull(tokenRequestParams);
        this.clientID = Objects.requireNonNull(clientID);
        this.confidentialClient = Objects.requireNonNull(confidentialClient);
        this.clientMetadata = Objects.requireNonNull(clientMetadata);
    }

    @Override
    public Issuer getIssuer() {
        return this.issuer;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public BearerAccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public TokenRequestParameters getTokenRequestParameters() {
        return this.tokenRequestParams;
    }

    @Override
    public ClientID getClientID() {
        return this.clientID;
    }

    @Override
    public Optional<Boolean> isConfidentialClient() {
        return this.confidentialClient;
    }

    @Override
    public JSONObject getClientMetadata() {
        return this.clientMetadata;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.tokenRequestParams.getScope() != null) {
            o.put((Object)"scope", (Object)this.tokenRequestParams.getScope().toStringList());
        }
        if (this.tokenRequestParams.getResources() != null) {
            o.put((Object)"resources", (Object)URIUtils.toStringList((Collection)this.tokenRequestParams.getResources()));
        }
        if (MapUtils.isNotEmpty((Map)this.tokenRequestParams.getCustomParameters())) {
            for (Map.Entry en : this.tokenRequestParams.getCustomParameters().entrySet()) {
                List values = (List)en.getValue();
                if (values == null) continue;
                if (values.size() == 1) {
                    o.put((Object)((String)en.getKey()), values.get(0));
                }
                if (values.size() <= 1) continue;
                o.put((Object)((String)en.getKey()), (Object)values);
            }
        }
        JSONObject clientJSONObject = new JSONObject((Map)this.clientMetadata);
        clientJSONObject.put((Object)"client_id", (Object)this.clientID.getValue());
        this.confidentialClient.ifPresent(bool -> clientJSONObject.put((Object)"confidential", bool));
        o.put((Object)"client", (Object)clientJSONObject);
        return o;
    }

    @Override
    public HTTPRequest toHTTPRequest(int httpConnectTimeout, int httpReadTimeout) {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.url);
        httpRequest.setAuthorization(this.accessToken.toAuthorizationHeader());
        httpRequest.setHeader("Issuer", new String[]{this.getIssuer().getValue()});
        httpRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        httpRequest.setBody(this.toJSONObject().toJSONString());
        httpRequest.setConnectTimeout(httpConnectTimeout);
        httpRequest.setReadTimeout(httpReadTimeout);
        return httpRequest;
    }

    public static BaseWebHandlerRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        String issuerHeader = httpRequest.getHeaderValue("Issuer");
        if (StringUtils.isBlank((CharSequence)issuerHeader)) {
            throw new ParseException("Missing Issuer header");
        }
        Issuer issuer = new Issuer(issuerHeader);
        BearerAccessToken accessToken = BearerAccessToken.parse((HTTPRequest)httpRequest);
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        final Scope scope = jsonObject.containsKey((Object)"scope") ? new Scope(JSONObjectUtils.getStringArray((JSONObject)jsonObject, (String)"scope")) : null;
        final LinkedList<URI> resources = new LinkedList<URI>();
        for (String resource : JSONObjectUtils.getStringList((JSONObject)jsonObject, (String)"resources", Collections.emptyList())) {
            if (!StringUtils.isNotBlank((CharSequence)resource)) continue;
            try {
                resources.add(new URI(resource));
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid resource URI: " + e.getMessage());
            }
        }
        JSONObject clientObject = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"client");
        ClientID clientID = new ClientID(JSONObjectUtils.getString((JSONObject)clientObject, (String)"client_id"));
        Optional<Boolean> confidentialClient = clientObject.containsKey((Object)"confidential") ? Optional.of(JSONObjectUtils.getBoolean((JSONObject)clientObject, (String)"confidential")) : Optional.empty();
        JSONObject clientMetadataObject = new JSONObject((Map)clientObject);
        clientMetadataObject.remove((Object)"client_id");
        clientMetadataObject.remove((Object)"confidential");
        final HashMap<String, List> customParams = new HashMap<String, List>();
        for (String key : jsonObject.keySet()) {
            if (Set.of("scope", "resources", "client").contains(key)) continue;
            if (jsonObject.get((Object)key) instanceof String) {
                customParams.put(key, List.of(JSONObjectUtils.getString((JSONObject)jsonObject, (String)key)));
            }
            if (!(jsonObject.get((Object)key) instanceof List)) continue;
            customParams.put(key, JSONObjectUtils.getStringList((JSONObject)jsonObject, (String)key));
        }
        return new BaseWebHandlerRequest(issuer, httpRequest.getURL(), accessToken, new TokenRequestParameters(){

            public Scope getScope() {
                return scope;
            }

            public List<URI> getResources() {
                return Collections.unmodifiableList(resources);
            }

            public Map<String, List<String>> getCustomParameters() {
                return Collections.unmodifiableMap(customParams);
            }
        }, clientID, confidentialClient, clientMetadataObject);
    }
}

