/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.clientcredentials;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.provider.spi.grants.ClientCredentialsGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.GrantAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.GrantHandlerContext;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseGrantDelegator;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseWebHandlerRequest;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.Utils;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.clientcredentials.Configuration;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Optional;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class ClientCredentialsGrantDelegator
extends BaseGrantDelegator
implements ClientCredentialsGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/clientGrantHandlerWebAPI.properties";

    public ClientCredentialsGrantDelegator() {
        super(CONFIG_FILE_PATH);
    }

    public Configuration loadConfiguration(Properties props) {
        return new Configuration(props);
    }

    public GrantType getGrantType() {
        return GrantType.CLIENT_CREDENTIALS;
    }

    public GrantAuthorization processGrant(TokenRequestParameters tokenRequestParams, ClientID clientID, ClientMetadata clientMetadata, GrantHandlerContext grantCtx) throws GeneralException {
        this.ensureEnabled();
        BaseWebHandlerRequest request = new BaseWebHandlerRequest(grantCtx.getIssuer(), this.getConfiguration().url, this.getConfiguration().apiAccessToken, this.keepAllowedCustomParams(tokenRequestParams), clientID, Optional.empty(), Utils.extractSelectedParameters(new OIDCClientMetadata(clientMetadata), this.getConfiguration().clientMetadata));
        JSONObject result = this.send(request);
        try {
            return GrantAuthorization.parse((JSONObject)result);
        }
        catch (Exception e) {
            Loggers.TOKEN.error("[{}0010] {} grant handler: Invalid response: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage(), (Object)e);
            throw new GeneralException(OAuth2Error.SERVER_ERROR);
        }
    }
}

