/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.password;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.provider.spi.grants.GrantHandlerContext;
import com.nimbusds.openid.connect.provider.spi.grants.PasswordGrantAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.PasswordGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseGrantDelegator;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.Utils;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.password.Configuration;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.password.PasswordGrantHandlerRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class PasswordGrantDelegator
extends BaseGrantDelegator
implements PasswordGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/passwordGrantHandlerWebAPI.properties";

    public PasswordGrantDelegator() {
        super(CONFIG_FILE_PATH);
    }

    public Configuration loadConfiguration(Properties props) {
        return new Configuration(props);
    }

    @Override
    public Configuration getConfiguration() {
        return (Configuration)this.config;
    }

    public GrantType getGrantType() {
        return GrantType.PASSWORD;
    }

    public PasswordGrantAuthorization processGrant(ResourceOwnerPasswordCredentialsGrant grant, TokenRequestParameters tokenRequestParams, ClientID clientID, boolean confidentialClient, OIDCClientMetadata clientMetadata, GrantHandlerContext handlerCtx) throws GeneralException {
        this.ensureEnabled();
        PasswordGrantHandlerRequest request = new PasswordGrantHandlerRequest(handlerCtx.getIssuer(), this.getConfiguration().url, this.getConfiguration().apiAccessToken, grant, this.keepAllowedCustomParams(tokenRequestParams), clientID, confidentialClient, Utils.extractSelectedParameters(clientMetadata, this.getConfiguration().clientMetadata));
        JSONObject result = this.send(request);
        try {
            return PasswordGrantAuthorization.parse((JSONObject)result);
        }
        catch (Exception e) {
            Loggers.TOKEN.error("[{}0010] {} grant handler: Invalid response: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage(), (Object)e);
            throw new GeneralException(OAuth2Error.SERVER_ERROR);
        }
    }
}

