/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.password;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseWebHandlerRequest;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class PasswordGrantHandlerRequest
extends BaseWebHandlerRequest {
    private final ResourceOwnerPasswordCredentialsGrant grant;

    public PasswordGrantHandlerRequest(Issuer issuer, URL url, BearerAccessToken accessToken, ResourceOwnerPasswordCredentialsGrant grant, TokenRequestParameters tokenRequestParams, ClientID clientID, boolean confidentialClient, JSONObject clientMetadata) {
        super(issuer, url, accessToken, tokenRequestParams, clientID, Optional.of(confidentialClient), clientMetadata);
        Objects.requireNonNull(grant);
        this.grant = grant;
    }

    public ResourceOwnerPasswordCredentialsGrant getGrant() {
        return this.grant;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject clientJSONObject;
        JSONObject o = super.toJSONObject();
        o.put((Object)"username", (Object)this.grant.getUsername());
        o.put((Object)"password", (Object)this.grant.getPassword().getValue());
        try {
            clientJSONObject = JSONObjectUtils.getJSONObject((JSONObject)o, (String)"client");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (!clientJSONObject.containsKey((Object)"require_auth_time")) {
            clientJSONObject.put((Object)"require_auth_time", (Object)false);
        }
        o.put((Object)"client", (Object)clientJSONObject);
        return o;
    }

    public static PasswordGrantHandlerRequest parse(HTTPRequest httpRequest) throws ParseException {
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        String username = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"username");
        jsonObject.remove((Object)"username");
        Secret password = new Secret(JSONObjectUtils.getString((JSONObject)jsonObject, (String)"password"));
        jsonObject.remove((Object)"password");
        httpRequest.setBody(jsonObject.toJSONString());
        ResourceOwnerPasswordCredentialsGrant grant = new ResourceOwnerPasswordCredentialsGrant(username, password);
        BaseWebHandlerRequest baseRequest = BaseWebHandlerRequest.parse(httpRequest);
        if (baseRequest.isConfidentialClient().isEmpty()) {
            throw new ParseException("Missing boolean client confidential flag");
        }
        return new PasswordGrantHandlerRequest(baseRequest.getIssuer(), baseRequest.getURL(), baseRequest.getAccessToken(), grant, baseRequest.getTokenRequestParameters(), baseRequest.getClientID(), baseRequest.isConfidentialClient().get(), baseRequest.getClientMetadata());
    }
}

