/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URL;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public final class AccessTokenIntrospection {
    private final @Nullable URL endpoint;
    private final TokenIntrospectionSuccessResponse response;

    public AccessTokenIntrospection(@Nullable URL endpoint, TokenIntrospectionSuccessResponse response) {
        this.endpoint = endpoint;
        if (!response.isActive()) {
            throw new IllegalArgumentException("The token must be active");
        }
        this.response = response;
    }

    public URL getURL() {
        return this.endpoint;
    }

    public TokenIntrospectionSuccessResponse getResponse() {
        return this.response;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.endpoint != null) {
            o.put((Object)"endpoint", (Object)this.endpoint.toString());
        }
        o.put((Object)"response", (Object)this.response.toJSONObject());
        return o;
    }

    public static AccessTokenIntrospection parse(JSONObject jsonObject) throws ParseException {
        URL endpoint = JSONObjectUtils.getURL((JSONObject)jsonObject, (String)"endpoint", null);
        TokenIntrospectionSuccessResponse response = TokenIntrospectionSuccessResponse.parse((JSONObject)JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"response"));
        if (!response.isActive()) {
            throw new ParseException("The token must be active");
        }
        return new AccessTokenIntrospection(endpoint, response);
    }
}

