/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseWebConfiguration;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.JWTVerificationConfiguration;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.RemoteAccessTokenIntrospectionConfiguration;
import com.thetransactioncompany.util.PropertyFilter;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
final class Configuration
extends BaseWebConfiguration {
    public static final String PREFIX = "op.grantHandler.tokenExchange.webAPI.";
    public static final String GRANT_SHORT_NAME = "Token exchange";
    public static final String LOG_PREFIX = "TEW";
    public final @Nullable Set<TokenTypeURI> subjectToken_types;
    public final @Nullable Set<TokenTypeURI> actorToken_types;
    public final @Nullable Set<TokenTypeURI> requestedToken_types;
    public final boolean subjectToken_accessTokenIntrospection_local_enable;
    public final Map<String, RemoteAccessTokenIntrospectionConfiguration> subjectToken_accessTokenIntrospection_remote;
    public final boolean subjectToken_accessTokenIntrospection_mustPass;
    public final Map<String, JWTVerificationConfiguration> subjectToken_jwtVerification;
    public final boolean subjectToken_jwtVerification_mustPass;

    Configuration(Properties props) throws ConfigurationException {
        super(PREFIX, props, GRANT_SHORT_NAME, LOG_PREFIX);
        PropertyRetriever pr = new PropertyRetriever(props, true);
        if (!this.enable) {
            this.subjectToken_types = null;
            this.actorToken_types = Collections.emptySet();
            this.requestedToken_types = null;
            this.subjectToken_accessTokenIntrospection_local_enable = false;
            this.subjectToken_accessTokenIntrospection_remote = Collections.emptyMap();
            this.subjectToken_accessTokenIntrospection_mustPass = false;
            this.subjectToken_jwtVerification = Collections.emptyMap();
            this.subjectToken_jwtVerification_mustPass = false;
            return;
        }
        try {
            this.subjectToken_types = Configuration.parseTokenTypes(pr, "op.grantHandler.tokenExchange.webAPI.subjectToken.types", true);
            if (this.subjectToken_types != null && this.subjectToken_types.isEmpty()) {
                throw new PropertyParseException("At least one op.grantHandler.tokenExchange.webAPI.subjectTokenTypes value must be configured", "op.grantHandler.tokenExchange.webAPI.subjectToken.types");
            }
            this.subjectToken_accessTokenIntrospection_local_enable = pr.getOptBoolean("op.grantHandler.tokenExchange.webAPI.subjectToken.accessTokenIntrospection.local.enable", false);
            Map remoteIntroProps = PropertyFilter.filterWithPrefixIntoMap((String)"op.grantHandler.tokenExchange.webAPI.subjectToken.accessTokenIntrospection.remote.", (Properties)Configuration.mergeWithSystemProperties(props));
            HashMap<String, RemoteAccessTokenIntrospectionConfiguration> remoteIntroConfig = new HashMap<String, RemoteAccessTokenIntrospectionConfiguration>();
            for (String id : remoteIntroProps.keySet()) {
                Properties restored = Configuration.restorePrefix("op.grantHandler.tokenExchange.webAPI.subjectToken.accessTokenIntrospection.remote.", id, (Properties)remoteIntroProps.get(id));
                remoteIntroConfig.put(id, RemoteAccessTokenIntrospectionConfiguration.parse("op.grantHandler.tokenExchange.webAPI.subjectToken.accessTokenIntrospection.remote." + id + ".", restored));
            }
            this.subjectToken_accessTokenIntrospection_remote = Collections.unmodifiableMap(remoteIntroConfig);
            this.subjectToken_accessTokenIntrospection_mustPass = pr.getOptBoolean("op.grantHandler.tokenExchange.webAPI.subjectToken.accessTokenIntrospection.mustPass", this.subjectToken_accessTokenIntrospection_local_enable || !this.subjectToken_accessTokenIntrospection_remote.isEmpty());
            Map jwtVerProps = PropertyFilter.filterWithPrefixIntoMap((String)"op.grantHandler.tokenExchange.webAPI.subjectToken.jwtVerification.", (Properties)Configuration.mergeWithSystemProperties(props));
            HashMap<String, JWTVerificationConfiguration> jwtVerConfig = new HashMap<String, JWTVerificationConfiguration>();
            for (String id : jwtVerProps.keySet()) {
                Properties restored = Configuration.restorePrefix("op.grantHandler.tokenExchange.webAPI.subjectToken.jwtVerification.", id, (Properties)jwtVerProps.get(id));
                jwtVerConfig.put(id, JWTVerificationConfiguration.parse("op.grantHandler.tokenExchange.webAPI.subjectToken.jwtVerification." + id + ".", restored));
            }
            this.subjectToken_jwtVerification = Collections.unmodifiableMap(jwtVerConfig);
            this.subjectToken_jwtVerification_mustPass = pr.getOptBoolean("op.grantHandler.tokenExchange.webAPI.subjectToken.jwtVerification.mustPass", !this.subjectToken_jwtVerification.isEmpty());
            this.actorToken_types = Configuration.parseTokenTypes(pr, "op.grantHandler.tokenExchange.webAPI.actorToken.types", false);
            this.requestedToken_types = Configuration.parseTokenTypes(pr, "op.grantHandler.tokenExchange.webAPI.requestedToken.types", true);
            if (this.requestedToken_types != null && this.requestedToken_types.isEmpty()) {
                throw new PropertyParseException("At least one op.grantHandler.tokenExchange.webAPI.requestedTokenTypes value must be configured", "op.grantHandler.tokenExchange.webAPI.requestedToken.types");
            }
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey());
        }
    }

    private static Properties mergeWithSystemProperties(Properties props) {
        Properties out = new Properties();
        out.putAll((Map<?, ?>)props);
        out.putAll((Map<?, ?>)System.getProperties());
        return out;
    }

    private static Properties restorePrefix(String prefix, String id, Properties props) {
        Properties out = new Properties();
        for (String name : props.stringPropertyNames()) {
            out.setProperty(prefix + id + "." + name, props.getProperty(name));
        }
        return out;
    }

    public static @Nullable Set<TokenTypeURI> parseTokenTypes(PropertyRetriever pr, String propertyName, boolean defaultAny) throws PropertyParseException {
        if (defaultAny && "*".equals(pr.getOptString(propertyName, "*"))) {
            return null;
        }
        if (!defaultAny) {
            String s = pr.getOptString(propertyName, null);
            if (s == null) {
                return Collections.emptySet();
            }
            if ("*".equals(s)) {
                return null;
            }
        }
        HashSet<TokenTypeURI> uris = new HashSet<TokenTypeURI>();
        for (String value : pr.getStringList(propertyName)) {
            try {
                uris.add(TokenTypeURI.parse((String)value));
            }
            catch (ParseException e) {
                throw new PropertyParseException(e.getMessage(), propertyName, value);
            }
        }
        return Collections.unmodifiableSet(uris);
    }

    @Override
    public void log() {
        super.log();
        if (!this.enable) {
            return;
        }
        Loggers.MAIN.info("[" + this.logPrefix + "0100] " + this.grantShortName + " grant handler: Accepted subject token types: {}", this.subjectToken_types == null ? "any" : this.subjectToken_types);
        Loggers.MAIN.info("[" + this.logPrefix + "0101] " + this.grantShortName + " grant handler: Local subject access token introspection: {}", (Object)this.subjectToken_accessTokenIntrospection_local_enable);
        Loggers.MAIN.info("[" + this.logPrefix + "0102] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}", (Object)(!this.subjectToken_accessTokenIntrospection_remote.isEmpty() ? 1 : 0));
        for (Map.Entry<String, RemoteAccessTokenIntrospectionConfiguration> entry : this.subjectToken_accessTokenIntrospection_remote.entrySet()) {
            Loggers.MAIN.info("[" + this.logPrefix + "0103] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}: Endpoint URL: {}", (Object)entry.getKey(), (Object)entry.getValue().endpoint);
            Loggers.MAIN.info("[" + this.logPrefix + "0104] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}: Endpoint authentication : {}", (Object)entry.getKey(), (Object)entry.getValue().authMethod);
            Loggers.MAIN.info("[" + this.logPrefix + "0105] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}: Client ID : {}", (Object)entry.getKey(), (Object)entry.getValue().clientID);
            Loggers.MAIN.info("[" + this.logPrefix + "0106] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}: Client secret : {}", (Object)entry.getKey(), (Object)(entry.getValue().clientSecret != null ? "[hidden]" : null));
            Loggers.MAIN.info("[" + this.logPrefix + "0107] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}: HTTP connect timeout: {} ms", (Object)entry.getKey(), (Object)entry.getValue().connectTimeout);
            Loggers.MAIN.info("[" + this.logPrefix + "0108] " + this.grantShortName + " grant handler: Remote subject access token introspection: {}: HTTP read timeout: {} ms", (Object)entry.getKey(), (Object)entry.getValue().readTimeout);
        }
        Loggers.MAIN.info("[" + this.logPrefix + "0115] " + this.grantShortName + " grant handler: Subject access token must pass introspection: {}", (Object)this.subjectToken_accessTokenIntrospection_mustPass);
        Loggers.MAIN.info("[" + this.logPrefix + "0109] " + this.grantShortName + " grant handler: Subject JWT verification: {}", (Object)(!this.subjectToken_jwtVerification.isEmpty() ? 1 : 0));
        for (Map.Entry<String, Object> entry : this.subjectToken_jwtVerification.entrySet()) {
            Loggers.MAIN.info("[" + this.logPrefix + "0110] " + this.grantShortName + " grant handler: Subject JWT verification: {}: JWK set URI: {}", (Object)entry.getKey(), (Object)((JWTVerificationConfiguration)entry.getValue()).jwkSetURI);
            Loggers.MAIN.info("[" + this.logPrefix + "0111] " + this.grantShortName + " grant handler: Subject JWT verification: {}: HTTP connect timeout: {} ms", (Object)entry.getKey(), (Object)((JWTVerificationConfiguration)entry.getValue()).connectTimeout);
            Loggers.MAIN.info("[" + this.logPrefix + "01112] " + this.grantShortName + " grant handler: Subject JWT verification: {}: HTTP read timeout: {} ms", (Object)entry.getKey(), (Object)((JWTVerificationConfiguration)entry.getValue()).readTimeout);
        }
        Loggers.MAIN.info("[" + this.logPrefix + "0116] " + this.grantShortName + " grant handler: Subject token must pass JWT verification: {}", (Object)this.subjectToken_jwtVerification_mustPass);
        Loggers.MAIN.info("[" + this.logPrefix + "0113] " + this.grantShortName + " grant handler: Accepted actor token types: {}", this.actorToken_types == null ? "any" : this.actorToken_types);
        Loggers.MAIN.info("[" + this.logPrefix + "0114] " + this.grantShortName + " grant handler: Accepted requested token types: {}", this.requestedToken_types == null ? "any" : this.requestedToken_types);
    }
}

