/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class JWTVerification {
    private final JWSHeader jwsHeader;
    private final JWTClaimsSet claims;

    public JWTVerification(JWSHeader jwsHeader, JWTClaimsSet claims) {
        this.jwsHeader = Objects.requireNonNull(jwsHeader);
        this.claims = Objects.requireNonNull(claims);
    }

    public JWSHeader getJWSHeader() {
        return this.jwsHeader;
    }

    public JWTClaimsSet getJWTClaimsSet() {
        return this.claims;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"jws_header", (Object)this.jwsHeader.toJSONObject());
        o.put((Object)"claims", (Object)this.claims.toJSONObject());
        return o;
    }

    public static JWTVerification parse(JSONObject jsonObject) throws ParseException {
        JSONObject jwsHeaderObject = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"jws_header");
        JSONObject claimsJSONObject = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"claims");
        try {
            return new JWTVerification(JWSHeader.parse((Map)jwsHeaderObject), JWTClaimsSet.parse((Map)claimsJSONObject));
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), (Throwable)e);
        }
    }
}

