/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWTVerificationConfiguration {
    public final URL jwkSetURI;
    public final int connectTimeout;
    public final int readTimeout;

    public JWTVerificationConfiguration(URL jwkSetURI, int connectTimeout, int readTimeout) {
        this.jwkSetURI = Objects.requireNonNull(jwkSetURI);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public static JWTVerificationConfiguration parse(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props, true);
        URL endpoint = pr.getURL(prefix + "jwkSetURI");
        int connectTimeout = pr.getOptInt(prefix + "connectTimeout", 0);
        int readTimeout = pr.getOptInt(prefix + "readTimeout", 0);
        return new JWTVerificationConfiguration(endpoint, connectTimeout, readTimeout);
    }
}

