/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.JWTVerification;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.JWTVerificationConfiguration;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWTVerifier {
    public static final Set<JWSAlgorithm> SUPPORTED_JWS_ALGS = JWTVerifier.merge(new Set[]{JWSAlgorithm.Family.RSA, JWSAlgorithm.Family.EC});
    public static final Set<JOSEObjectType> ALLOWED_TYPES = new HashSet<JOSEObjectType>(Arrays.asList(JOSEObjectType.JWT, new JOSEObjectType("at+JWT"), null));
    protected final Map<String, JWTProcessor<?>> jwtProcessors = new HashMap();

    @SafeVarargs
    private static Set<JWSAlgorithm> merge(Set<JWSAlgorithm> ... sets) {
        HashSet<JWSAlgorithm> out = new HashSet<JWSAlgorithm>();
        for (Set<JWSAlgorithm> set : sets) {
            out.addAll(set);
        }
        return Collections.unmodifiableSet(out);
    }

    public JWTVerifier(Map<String, JWTVerificationConfiguration> config) {
        for (Map.Entry<String, JWTVerificationConfiguration> en : config.entrySet()) {
            DefaultJWTProcessor proc = new DefaultJWTProcessor();
            proc.setJWSKeySelector((JWSKeySelector)new JWSVerificationKeySelector(SUPPORTED_JWS_ALGS, (JWKSource)new RemoteJWKSet(en.getValue().jwkSetURI, (ResourceRetriever)new DefaultResourceRetriever(en.getValue().connectTimeout, en.getValue().readTimeout))));
            proc.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(ALLOWED_TYPES));
            this.jwtProcessors.put(en.getKey(), (JWTProcessor<?>)proc);
        }
    }

    public boolean isConfigured() {
        return !this.jwtProcessors.isEmpty();
    }

    public JWTVerification verify(Token token) throws ParseException, BadJOSEException, JOSEException {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Not configured");
        }
        SignedJWT signedJWT = SignedJWT.parse((String)token.getValue());
        BadJOSEException lastBadJOSEException = null;
        for (JWTProcessor<?> p : this.jwtProcessors.values()) {
            try {
                JWTClaimsSet claims = p.process(signedJWT, null);
                return new JWTVerification(signedJWT.getHeader(), claims);
            }
            catch (BadJOSEException e) {
                lastBadJOSEException = e;
            }
        }
        assert (lastBadJOSEException != null);
        throw lastBadJOSEException;
    }
}

