/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.AccessTokenIntrospection;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.ClientException;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.RemoteAccessTokenIntrospectionConfiguration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RemoteAccessTokenIntrospectionClient {
    protected final Map<String, RemoteAccessTokenIntrospectionConfiguration> config;

    public RemoteAccessTokenIntrospectionClient(Map<String, RemoteAccessTokenIntrospectionConfiguration> config) {
        this.config = Objects.requireNonNull(config);
    }

    public boolean isConfigured() {
        return !this.config.isEmpty();
    }

    private static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public AccessTokenIntrospection introspect(Token token) throws GeneralException, ClientException {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Not configured");
        }
        GeneralException lastException = null;
        for (RemoteAccessTokenIntrospectionConfiguration c : this.config.values()) {
            TokenIntrospectionResponse response;
            HTTPResponse httpResponse;
            ClientAuthentication clientAuth = c.toClientAuthentication();
            TokenIntrospectionRequest request = new TokenIntrospectionRequest(RemoteAccessTokenIntrospectionClient.toURI(c.endpoint), clientAuth, token);
            HTTPRequest httpRequest = request.toHTTPRequest();
            httpRequest.setConnectTimeout(c.connectTimeout);
            httpRequest.setReadTimeout(c.readTimeout);
            try {
                httpResponse = httpRequest.send();
            }
            catch (IOException e) {
                throw new ClientException(e);
            }
            try {
                response = TokenIntrospectionResponse.parse((HTTPResponse)httpResponse);
            }
            catch (ParseException e) {
                throw new ClientException("Invalid introspection response from " + c.endpoint + " : " + e.getMessage(), (Exception)((Object)e));
            }
            if (!response.indicatesSuccess()) {
                throw new ClientException("Introspection error at " + c.endpoint + " : HTTP " + response.toErrorResponse().getErrorObject().getHTTPStatusCode());
            }
            if (!response.toSuccessResponse().isActive()) {
                lastException = new GeneralException("Invalid access token according to " + c.endpoint, OAuth2Error.INVALID_REQUEST);
                continue;
            }
            return new AccessTokenIntrospection(c.endpoint, response.toSuccessResponse());
        }
        assert (lastException != null);
        throw lastException;
    }
}

