/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public final class RemoteAccessTokenIntrospectionConfiguration {
    public final URL endpoint;
    public static final Set<ClientAuthenticationMethod> SUPPORTED_AUTH_METHODS = Set.of(ClientAuthenticationMethod.NONE, ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
    public final ClientAuthenticationMethod authMethod;
    public final @Nullable ClientID clientID;
    public final @Nullable Secret clientSecret;
    public final int connectTimeout;
    public final int readTimeout;

    public RemoteAccessTokenIntrospectionConfiguration(URL endpoint, ClientAuthenticationMethod authMethod, @Nullable ClientID clientID, @Nullable Secret clientSecret, int connectTimeout, int readTimeout) {
        this.endpoint = Objects.requireNonNull(endpoint);
        Objects.requireNonNull(authMethod);
        if (!SUPPORTED_AUTH_METHODS.contains(authMethod)) {
            throw new IllegalArgumentException("Unsupported client authentication method: " + authMethod);
        }
        this.authMethod = authMethod;
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)authMethod)) {
            if (clientID == null) {
                throw new IllegalArgumentException("Basic authentication requires a client ID");
            }
            if (clientSecret == null) {
                throw new IllegalArgumentException("Basic authentication requires a client secret");
            }
        }
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public @Nullable ClientAuthentication toClientAuthentication() {
        if (ClientAuthenticationMethod.NONE.equals((Object)this.authMethod)) {
            return null;
        }
        assert (this.clientID != null);
        assert (this.clientSecret != null);
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)this.authMethod)) {
            return new ClientSecretBasic(this.clientID, this.clientSecret);
        }
        throw new IllegalStateException();
    }

    public static RemoteAccessTokenIntrospectionConfiguration parse(String prefix, Properties props) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props, true);
        URL endpoint = pr.getURL(prefix + "endpoint");
        ClientAuthenticationMethod authMethod = new ClientAuthenticationMethod(pr.getOptString(prefix + "authMethod", ClientAuthenticationMethod.NONE.getValue()));
        if (!SUPPORTED_AUTH_METHODS.contains(authMethod)) {
            throw new PropertyParseException("Unsupported client authentication method: " + authMethod, prefix + "authMethod");
        }
        ClientID clientID = null;
        String clientIDString = pr.getOptString(prefix + "clientID", null);
        if (StringUtils.isNotBlank((CharSequence)clientIDString)) {
            clientID = new ClientID(clientIDString);
        }
        Secret clientSecret = null;
        String secretString = pr.getOptString(prefix + "clientSecret", null);
        if (StringUtils.isNotBlank((CharSequence)secretString)) {
            clientSecret = new Secret(secretString);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)authMethod)) {
            if (clientID == null) {
                throw new PropertyParseException("Basic authentication requires a client ID", prefix + "clientID");
            }
            if (clientSecret == null) {
                throw new PropertyParseException("Basic authentication requires a client secret", prefix + "clientSecret");
            }
        }
        int connectTimeout = pr.getOptInt(prefix + "connectTimeout", 0);
        int readTimeout = pr.getOptInt(prefix + "readTimeout", 0);
        return new RemoteAccessTokenIntrospectionConfiguration(endpoint, authMethod, clientID, clientSecret, connectTimeout, readTimeout);
    }
}

