/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.nimbusds.oauth2.sdk.tokenexchange.TokenExchangeGrant;
import com.nimbusds.openid.connect.provider.spi.InitContext;
import com.nimbusds.openid.connect.provider.spi.grants.GrantHandlerContext;
import com.nimbusds.openid.connect.provider.spi.grants.TokenExchangeAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.TokenExchangeGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.TokenIntrospection;
import com.nimbusds.openid.connect.provider.spi.grants.TokenIssueHelpers;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseGrantDelegator;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.Utils;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.AccessTokenIntrospection;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.ClientException;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.Configuration;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.JWTVerification;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.JWTVerifier;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.RemoteAccessTokenIntrospectionClient;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.TokenExchangeGrantHandlerRequest;
import com.nimbusds.openid.connect.provider.spi.tokens.AccessTokenAuthorization;
import com.nimbusds.openid.connect.provider.spi.tokens.introspection.DefaultTokenIntrospectionResponseComposer;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.text.ParseException;
import java.util.Properties;
import net.minidev.json.JSONObject;

public class TokenExchangeGrantDelegator
extends BaseGrantDelegator
implements TokenExchangeGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/tokenExchangeGrantHandlerWebAPI.properties";
    private RemoteAccessTokenIntrospectionClient introspectionClient;
    private JWTVerifier jwtVerifier;

    public TokenExchangeGrantDelegator() {
        super(CONFIG_FILE_PATH);
    }

    public Configuration loadConfiguration(Properties props) {
        return new Configuration(props);
    }

    @Override
    public void init(InitContext initContext) throws Exception {
        super.init(initContext);
        if (!this.getConfiguration().enable) {
            return;
        }
        this.jwtVerifier = new JWTVerifier(this.getConfiguration().subjectToken_jwtVerification);
        this.introspectionClient = new RemoteAccessTokenIntrospectionClient(this.getConfiguration().subjectToken_accessTokenIntrospection_remote);
    }

    @Override
    public Configuration getConfiguration() {
        return (Configuration)this.config;
    }

    public GrantType getGrantType() {
        return GrantType.TOKEN_EXCHANGE;
    }

    protected void ensureAcceptedTokenTypes(TokenExchangeGrant grant) throws GeneralException {
        if (this.getConfiguration().subjectToken_types != null && !this.getConfiguration().subjectToken_types.contains(grant.getSubjectTokenType())) {
            throw new GeneralException(OAuth2Error.INVALID_REQUEST.setDescription("subject_token_type value not accepted"));
        }
        if (grant.getActorTokenType() != null && this.getConfiguration().actorToken_types != null && !this.getConfiguration().actorToken_types.contains(grant.getActorTokenType())) {
            throw new GeneralException(OAuth2Error.INVALID_REQUEST.setDescription("actor_token_type value not accepted"));
        }
        if (grant.getRequestedTokenType() != null && this.getConfiguration().requestedToken_types != null && !this.getConfiguration().requestedToken_types.contains(grant.getRequestedTokenType())) {
            throw new GeneralException(OAuth2Error.INVALID_REQUEST.setDescription("requested_token_type value not accepted"));
        }
    }

    static boolean infersAccessToken(TokenTypeURI tokenTypeURI) {
        return TokenTypeURI.ACCESS_TOKEN.equals((Object)tokenTypeURI);
    }

    static boolean infersJWT(TokenTypeURI tokenTypeURI) {
        return TokenTypeURI.JWT.equals((Object)tokenTypeURI) || TokenTypeURI.ACCESS_TOKEN.equals((Object)tokenTypeURI) || TokenTypeURI.ID_TOKEN.equals((Object)tokenTypeURI);
    }

    public TokenExchangeAuthorization processGrant(TokenExchangeGrant grant, TokenRequestParameters tokenRequestParams, ClientID clientID, boolean confidentialClient, OIDCClientMetadata clientMetadata, TokenIntrospection tokenIntrospection, TokenIssueHelpers tokenIssueHelpers, GrantHandlerContext handlerCtx) throws GeneralException {
        this.ensureEnabled();
        this.ensureAcceptedTokenTypes(grant);
        AccessTokenIntrospection subjectTokenIntrospection = null;
        if (this.getConfiguration().subjectToken_accessTokenIntrospection_local_enable && TokenExchangeGrantDelegator.infersAccessToken(grant.getSubjectTokenType())) {
            AccessTokenAuthorization tokenAuthz = tokenIntrospection.getAccessTokenAuthorization();
            if (tokenAuthz != null) {
                subjectTokenIntrospection = new AccessTokenIntrospection(null, new DefaultTokenIntrospectionResponseComposer().compose(tokenAuthz, null));
                Loggers.TOKEN.debug("[{}0205] {} grant handler: Validated subject_token as local access token", (Object)this.config.logPrefix, (Object)this.config.grantShortName);
            } else {
                Loggers.TOKEN.debug("[{}0204] {} grant handler: subject_token not a valid local access token", (Object)this.config.logPrefix, (Object)this.config.grantShortName);
            }
        }
        if (subjectTokenIntrospection == null && TokenExchangeGrantDelegator.infersAccessToken(grant.getSubjectTokenType()) && this.introspectionClient.isConfigured()) {
            try {
                subjectTokenIntrospection = this.introspectionClient.introspect(grant.getSubjectToken());
                Loggers.TOKEN.debug("[{}0207] {} grant handler: Validated subject_token as 3rd party access token", (Object)this.config.logPrefix, (Object)this.config.grantShortName);
            }
            catch (GeneralException e) {
                Loggers.TOKEN.debug("[{}0203] {} grant handler: subject_token not a valid 3rd party access token: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage());
            }
            catch (ClientException e) {
                Loggers.TOKEN.error("[{}0206] {} grant handler: subject_token remote introspection error: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage());
                throw new GeneralException(OAuth2Error.SERVER_ERROR);
            }
        }
        if (subjectTokenIntrospection == null && this.getConfiguration().subjectToken_accessTokenIntrospection_mustPass) {
            throw new GeneralException(OAuth2Error.INVALID_REQUEST.setDescription("Invalid subject_token"));
        }
        JWTVerification subjectJWTVerification = null;
        if (subjectTokenIntrospection == null && TokenExchangeGrantDelegator.infersJWT(grant.getSubjectTokenType()) && this.jwtVerifier.isConfigured()) {
            try {
                subjectJWTVerification = this.jwtVerifier.verify(grant.getSubjectToken());
                Loggers.TOKEN.debug("[{}0208] {} grant handler: Validated subject_token as JWT", (Object)this.config.logPrefix, (Object)this.config.grantShortName);
            }
            catch (BadJOSEException | ParseException e) {
                Loggers.TOKEN.debug("[{}0201] {} grant handler: Invalid subject_token JWT: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage());
                if (this.getConfiguration().subjectToken_jwtVerification_mustPass) {
                    throw new GeneralException(OAuth2Error.INVALID_REQUEST.setDescription("Invalid subject_token"));
                }
            }
            catch (JOSEException e) {
                Loggers.TOKEN.error("[{}0202] {} grant handler: subject_token JWT verification error: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage());
                throw new GeneralException(OAuth2Error.SERVER_ERROR);
            }
        }
        TokenExchangeGrantHandlerRequest request = new TokenExchangeGrantHandlerRequest(handlerCtx.getIssuer(), this.getConfiguration().url, this.getConfiguration().apiAccessToken, grant, this.keepAllowedCustomParams(tokenRequestParams), subjectTokenIntrospection, subjectJWTVerification, clientID, confidentialClient, Utils.extractSelectedParameters(clientMetadata, this.getConfiguration().clientMetadata));
        JSONObject result = this.send(request);
        try {
            return TokenExchangeAuthorization.parse((JSONObject)result);
        }
        catch (Exception e) {
            Loggers.TOKEN.error("[{}0200] {} grant handler: Invalid response: {}", (Object)this.config.logPrefix, (Object)this.config.grantShortName, (Object)e.getMessage(), (Object)e);
            throw new GeneralException(OAuth2Error.SERVER_ERROR);
        }
    }
}

