/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.nimbusds.oauth2.sdk.token.TypelessToken;
import com.nimbusds.oauth2.sdk.tokenexchange.TokenExchangeGrant;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.BaseWebHandlerRequest;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.AccessTokenIntrospection;
import com.nimbusds.openid.connect.provider.spi.impl.grants.handlers.web.tokenexchange.JWTVerification;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minidev.json.JSONObject;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TokenExchangeGrantHandlerRequest
extends BaseWebHandlerRequest {
    private final TokenExchangeGrant grant;
    private final @Nullable AccessTokenIntrospection accessTokenIntrospection;
    private final @Nullable JWTVerification jwtVerification;

    public TokenExchangeGrantHandlerRequest(Issuer issuer, URL url, BearerAccessToken accessToken, TokenExchangeGrant grant, TokenRequestParameters tokenRequestParams, @Nullable AccessTokenIntrospection accessTokenIntrospection, @Nullable JWTVerification jwtVerification, ClientID clientID, boolean confidentialClient, JSONObject clientMetadata) {
        super(issuer, url, accessToken, tokenRequestParams, clientID, Optional.of(confidentialClient), clientMetadata);
        this.grant = Objects.requireNonNull(grant);
        this.accessTokenIntrospection = accessTokenIntrospection;
        this.jwtVerification = jwtVerification;
    }

    public TokenExchangeGrant getGrant() {
        return this.grant;
    }

    public @Nullable AccessTokenIntrospection getAccessTokenIntrospection() {
        return this.accessTokenIntrospection;
    }

    public @Nullable JWTVerification getSubjectTokenVerification() {
        return this.jwtVerification;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"subject_token", (Object)this.getGrant().getSubjectToken().getValue());
        o.put((Object)"subject_token_type", (Object)this.getGrant().getSubjectTokenType().getURI().toString());
        if (this.getAccessTokenIntrospection() != null) {
            o.put((Object)"subject_token_introspection", (Object)this.getAccessTokenIntrospection().toJSONObject());
        }
        if (this.getSubjectTokenVerification() != null) {
            o.put((Object)"subject_token_verification", (Object)this.getSubjectTokenVerification().toJSONObject());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getGrant().getAudience())) {
            o.put((Object)"audience", (Object)Audience.toStringList((List)this.getGrant().getAudience()));
        }
        if (this.getGrant().getRequestedTokenType() != null) {
            o.put((Object)"requested_token_type", (Object)this.getGrant().getRequestedTokenType().getURI().toString());
        }
        if (this.getGrant().getActorToken() != null) {
            o.put((Object)"actor_token", (Object)this.getGrant().getActorToken().getValue());
        }
        if (this.getGrant().getActorTokenType() != null) {
            o.put((Object)"actor_token_type", (Object)this.getGrant().getActorTokenType().getURI().toString());
        }
        return o;
    }

    public static TokenExchangeGrantHandlerRequest parse(HTTPRequest httpRequest) throws ParseException {
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        TypelessToken subjectToken = new TypelessToken(JSONObjectUtils.getString((JSONObject)jsonObject, (String)"subject_token"));
        jsonObject.remove((Object)"subject_token");
        TokenTypeURI subjectTokenType = TokenTypeURI.parse((String)JSONObjectUtils.getString((JSONObject)jsonObject, (String)"subject_token_type"));
        jsonObject.remove((Object)"subject_token_type");
        AccessTokenIntrospection tokenIntrospection = null;
        if (jsonObject.containsKey((Object)"subject_token_introspection")) {
            tokenIntrospection = AccessTokenIntrospection.parse(JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"subject_token_introspection"));
        }
        JWTVerification jwtVerification = null;
        if (jsonObject.containsKey((Object)"subject_token_verification")) {
            jwtVerification = JWTVerification.parse(JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"subject_token_verification"));
        }
        List audienceList = null;
        if (jsonObject.containsKey((Object)"audience")) {
            audienceList = Audience.create((List)JSONObjectUtils.getStringList((JSONObject)jsonObject, (String)"audience"));
            jsonObject.remove((Object)"audience");
        }
        TokenTypeURI requestedTokenType = null;
        if (jsonObject.containsKey((Object)"requested_token_type")) {
            requestedTokenType = TokenTypeURI.parse((String)JSONObjectUtils.getString((JSONObject)jsonObject, (String)"requested_token_type"));
            jsonObject.remove((Object)"requested_token_type");
        }
        TypelessToken actorToken = null;
        if (jsonObject.containsKey((Object)"actor_token")) {
            actorToken = new TypelessToken(JSONObjectUtils.getString((JSONObject)jsonObject, (String)"actor_token"));
            jsonObject.remove((Object)"actor_token");
        }
        TokenTypeURI actorTokenType = null;
        if (jsonObject.containsKey((Object)"actor_token_type")) {
            actorTokenType = TokenTypeURI.parse((String)JSONObjectUtils.getString((JSONObject)jsonObject, (String)"actor_token_type"));
            jsonObject.remove((Object)"actor_token_type");
        }
        TokenExchangeGrant grant = new TokenExchangeGrant((Token)subjectToken, subjectTokenType, (Token)actorToken, actorTokenType, requestedTokenType, audienceList);
        httpRequest.setBody(jsonObject.toJSONString());
        BaseWebHandlerRequest baseRequest = BaseWebHandlerRequest.parse(httpRequest);
        if (baseRequest.isConfidentialClient().isEmpty()) {
            throw new ParseException("Missing boolean client confidential flag");
        }
        return new TokenExchangeGrantHandlerRequest(baseRequest.getIssuer(), baseRequest.getURL(), baseRequest.getAccessToken(), grant, baseRequest.getTokenRequestParameters(), tokenIntrospection, jwtVerification, baseRequest.getClientID(), baseRequest.isConfidentialClient().get(), baseRequest.getClientMetadata());
    }
}

