/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.nativesso.handlers;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.provider.spi.impl.common.AccessTokenConfig;
import com.nimbusds.openid.connect.provider.spi.impl.common.Loggers;
import com.nimbusds.openid.connect.provider.spi.impl.common.RefreshTokenConfig;
import com.nimbusds.openid.connect.sdk.claims.ClaimsTransport;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
final class Configuration
implements LoggableConfiguration {
    public static final String PREFIX = "op.deviceSSOHandler.";
    public final boolean enable;
    public final @Nullable Scope scopeRequiringInteraction;
    public final @Nullable AccessTokenConfig accessToken;
    public final @Nullable RefreshTokenConfig refreshToken;
    public final @Nullable ClaimsTransport claimsTransport;

    Configuration(Properties props) throws ConfigurationException {
        PropertyRetriever pr = new PropertyRetriever(props, true);
        try {
            this.enable = pr.getOptBoolean("op.deviceSSOHandler.enable", false);
            if (!this.enable) {
                this.scopeRequiringInteraction = null;
                this.accessToken = null;
                this.refreshToken = null;
                this.claimsTransport = null;
                return;
            }
            this.scopeRequiringInteraction = Scope.parse((String)pr.getOptString("op.deviceSSOHandler.scopeRequiringInteraction", ""));
            this.accessToken = new AccessTokenConfig(PREFIX, props);
            this.refreshToken = new RefreshTokenConfig(PREFIX, props);
            this.claimsTransport = (ClaimsTransport)pr.getOptEnum("op.deviceSSOHandler.claimsTransport", ClaimsTransport.class, (Enum)ClaimsTransport.getDefault());
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey(), (Throwable)e);
        }
    }

    public void log() {
        Loggers.MAIN.info("[DS0000] Device SSO handler enabled: {}", (Object)this.enable);
        if (!this.enable) {
            return;
        }
        Loggers.MAIN.info("[DS0001] Device SSO handler scope values requiring interaction: {}", (Object)this.scopeRequiringInteraction);
        this.accessToken.log("DS");
        this.refreshToken.log("DS");
        Loggers.MAIN.info("[DS0002] Device SSO handler preferred claims transport: {}", (Object)this.claimsTransport);
    }
}

