/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.impl.nativesso.handlers;

import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.provider.spi.InitContext;
import com.nimbusds.openid.connect.provider.spi.grants.AccessTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.ClaimsSpec;
import com.nimbusds.openid.connect.provider.spi.grants.IDTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.RefreshTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.TokenRequestParameters;
import com.nimbusds.openid.connect.provider.spi.impl.common.ClientMetadataFilter;
import com.nimbusds.openid.connect.provider.spi.impl.common.ScopeUtils;
import com.nimbusds.openid.connect.provider.spi.impl.nativesso.handlers.Configuration;
import com.nimbusds.openid.connect.provider.spi.internal.sessionstore.SubjectSession;
import com.nimbusds.openid.connect.provider.spi.nativesso.BackChannelDeviceSSOAuthorization;
import com.nimbusds.openid.connect.provider.spi.nativesso.DeviceSSOHandler;
import com.nimbusds.openid.connect.provider.spi.nativesso.DeviceSSOHandlerContext;
import com.nimbusds.openid.connect.sdk.OIDCError;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;

@ThreadSafe
public class LocalDeviceSSOHandler
implements DeviceSSOHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/deviceSSOHandler.properties";
    private Configuration config;

    public void init(InitContext initContext) throws Exception {
        Properties props = new Properties();
        InputStream inputStream = initContext.getResourceAsStream(CONFIG_FILE_PATH);
        if (inputStream != null) {
            props.load(inputStream);
        }
        this.config = new Configuration(props);
        this.config.log();
    }

    public boolean isEnabled() {
        return this.config.enable;
    }

    @Nullable Configuration getConfiguration() {
        return this.config;
    }

    public BackChannelDeviceSSOAuthorization processBackChannelRequest(Subject subject, IDTokenClaimsSet idTokenClaimsSet, SubjectSession deviceSession, TokenRequestParameters tokenRequestParams, ClientID clientID, boolean confidentialClient, OIDCClientMetadata clientMetadata, DeviceSSOHandlerContext handlerCtx) throws GeneralException {
        if (!this.config.enable) {
            throw new GeneralException("Device SSO handler disabled", OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        }
        Scope authorizedScope = ScopeUtils.resolveAuthorizedScope(tokenRequestParams.getScope(), clientMetadata.getScope());
        assert (this.config.scopeRequiringInteraction != null);
        for (Scope.Value requiresInteraction : this.config.scopeRequiringInteraction) {
            if (!authorizedScope.contains((Object)requiresInteraction)) continue;
            throw new GeneralException(OIDCError.INTERACTION_REQUIRED);
        }
        if (clientMetadata.getDefaultMaxAge() > -1) {
            if (clientMetadata.getDefaultMaxAge() == 0) {
                throw new GeneralException(OIDCError.INTERACTION_REQUIRED.setDescription("Login required"));
            }
            if (deviceSession.getSubjectAuthentication().getTime().plusSeconds(clientMetadata.getDefaultMaxAge()).isBefore(Instant.now())) {
                throw new GeneralException(OIDCError.INTERACTION_REQUIRED.setDescription("Login required"));
            }
        }
        assert (this.config.accessToken != null);
        assert (this.config.refreshToken != null);
        return new BackChannelDeviceSSOAuthorization(authorizedScope, new AccessTokenSpec(this.config.accessToken.lifetime, this.config.accessToken.audienceList, this.config.accessToken.encoding, this.config.accessToken.encrypt), new RefreshTokenSpec(this.config.refreshToken.issue, this.config.refreshToken.lifetime, this.config.refreshToken.maxIdleTime, this.config.refreshToken.rotate), new IDTokenSpec(true, 0L, clientMetadata.requiresAuthTime() ? LocalDeviceSSOHandler.resolveSubjectAuthTime(deviceSession) : null, deviceSession.getSubjectAuthentication().getACR(), deviceSession.getSubjectAuthentication().getAMRList(), null), new ClaimsSpec(handlerCtx.resolveClaimNames(authorizedScope), null, null, null, this.config.claimsTransport), new ClientMetadataFilter(this.config.accessToken.includeClientMetadataFields).filter((ClientMetadata)clientMetadata));
    }

    private static @Nullable Date resolveSubjectAuthTime(SubjectSession deviceSession) {
        Instant authTime = deviceSession.getSubjectAuthentication().getTime();
        if (authTime == null) {
            return null;
        }
        return Date.from(authTime);
    }
}

