/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.entities;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkEntry;
import com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkIssuerMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public abstract class CommonFederationClaimsSet
extends CommonClaimsSet {
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String METADATA_CLAIM_NAME = "metadata";
    public static final String TRUST_MARKS_CLAIM_NAME = "trust_marks";

    protected CommonFederationClaimsSet() {
    }

    protected CommonFederationClaimsSet(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        EntityID.parse(this.getIssuer());
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        EntityID.parse(this.getSubject());
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
        if (this.getExpirationTime() == null) {
            throw new ParseException("Missing exp (expiration) claim");
        }
    }

    public EntityID getIssuerEntityID() {
        return new EntityID(this.getIssuer().getValue());
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.getSubject().getValue());
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public JSONObject getMetadata(EntityType type) {
        JSONObject o = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (o == null) {
            return null;
        }
        try {
            return JSONObjectUtils.getJSONObject(o, type.getValue(), null);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public OIDCClientMetadata getRPMetadata() {
        JSONObject o = this.getMetadata(EntityType.OPENID_RELYING_PARTY);
        if (o == null) {
            return null;
        }
        try {
            return OIDCClientMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public OIDCProviderMetadata getOPMetadata() {
        JSONObject o = this.getMetadata(EntityType.OPENID_PROVIDER);
        if (o == null) {
            return null;
        }
        try {
            return OIDCProviderMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public ClientMetadata getOAuthClientMetadata() {
        JSONObject o = this.getMetadata(EntityType.OAUTH_CLIENT);
        if (o == null) {
            return null;
        }
        try {
            return ClientMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public AuthorizationServerMetadata getASMetadata() {
        JSONObject o = this.getMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER);
        if (o == null) {
            return null;
        }
        try {
            return AuthorizationServerMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public FederationEntityMetadata getFederationEntityMetadata() {
        JSONObject o = this.getMetadata(EntityType.FEDERATION_ENTITY);
        if (o == null) {
            return null;
        }
        try {
            return FederationEntityMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public TrustMarkIssuerMetadata getTrustMarkIssuerMetadata() {
        JSONObject o = this.getMetadata(EntityType.TRUST_MARK_ISSUER);
        if (o == null) {
            return null;
        }
        try {
            return TrustMarkIssuerMetadata.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public List<TrustMarkEntry> getTrustMarks() {
        List<JSONObject> jsonObjects;
        JSONArray array = this.getJSONArrayClaim(TRUST_MARKS_CLAIM_NAME);
        if (array == null) {
            return null;
        }
        try {
            jsonObjects = JSONArrayUtils.toJSONObjectList(array);
        }
        catch (ParseException e) {
            return null;
        }
        LinkedList<TrustMarkEntry> marks = new LinkedList<TrustMarkEntry>();
        for (JSONObject o : jsonObjects) {
            try {
                marks.add(TrustMarkEntry.parse(o));
            }
            catch (ParseException e) {
                return null;
            }
        }
        return marks;
    }

    public void setTrustMarks(List<TrustMarkEntry> marks) {
        if (marks != null) {
            JSONArray array = new JSONArray();
            for (TrustMarkEntry en : marks) {
                array.add((Object)en.toJSONObject());
            }
            this.setClaim(TRUST_MARKS_CLAIM_NAME, array);
        } else {
            this.setClaim(TRUST_MARKS_CLAIM_NAME, null);
        }
    }
}

