/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.entities;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.util.List;
import net.minidev.json.JSONObject;

public class FederationEntityMetadata {
    private final URI federationFetchEndpoint;
    private URI federationListEndpoint;
    private URI federationResolveEndpoint;
    private String organizationName;
    private List<String> contacts;
    private URI policyURI;
    private URI homepageURI;

    public FederationEntityMetadata(URI federationFetchEndpoint) {
        this.federationFetchEndpoint = federationFetchEndpoint;
    }

    public URI getFederationFetchEndpointURI() {
        return this.federationFetchEndpoint;
    }

    public URI getFederationListEndpointURI() {
        return this.federationListEndpoint;
    }

    public void setFederationListEndpointURI(URI federationListEndpoint) {
        this.federationListEndpoint = federationListEndpoint;
    }

    public URI getFederationResolveEndpointURI() {
        return this.federationResolveEndpoint;
    }

    public void setFederationResolveEndpointURI(URI federationResolveEndpoint) {
        this.federationResolveEndpoint = federationResolveEndpoint;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURI = policyURI;
    }

    public URI getHomepageURI() {
        return this.homepageURI;
    }

    public void setHomepageURI(URI homepageURI) {
        this.homepageURI = homepageURI;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.getFederationFetchEndpointURI() != null) {
            o.put((Object)"federation_fetch_endpoint", (Object)this.getFederationFetchEndpointURI().toString());
        }
        if (this.getFederationListEndpointURI() != null) {
            o.put((Object)"federation_list_endpoint", (Object)this.getFederationListEndpointURI().toString());
        }
        if (this.getFederationResolveEndpointURI() != null) {
            o.put((Object)"federation_resolve_endpoint", (Object)this.getFederationResolveEndpointURI().toString());
        }
        if (this.getOrganizationName() != null) {
            o.put((Object)"organization_name", (Object)this.getOrganizationName());
        }
        if (this.getContacts() != null) {
            o.put((Object)"contacts", this.getContacts());
        }
        if (this.getPolicyURI() != null) {
            o.put((Object)"policy_uri", (Object)this.getPolicyURI().toString());
        }
        if (this.getHomepageURI() != null) {
            o.put((Object)"homepage_uri", (Object)this.getHomepageURI().toString());
        }
        return o;
    }

    public static FederationEntityMetadata parse(JSONObject jsonObject) throws ParseException {
        FederationEntityMetadata metadata = new FederationEntityMetadata(JSONObjectUtils.getURI(jsonObject, "federation_fetch_endpoint", null));
        metadata.setFederationListEndpointURI(JSONObjectUtils.getURI(jsonObject, "federation_list_endpoint", null));
        metadata.setFederationResolveEndpointURI(JSONObjectUtils.getURI(jsonObject, "federation_resolve_endpoint", null));
        metadata.setOrganizationName(JSONObjectUtils.getString(jsonObject, "organization_name", null));
        metadata.setContacts(JSONObjectUtils.getStringList(jsonObject, "contacts", null));
        metadata.setPolicyURI(JSONObjectUtils.getURI(jsonObject, "policy_uri", null));
        metadata.setHomepageURI(JSONObjectUtils.getURI(jsonObject, "homepage_uri", null));
        return metadata;
    }

    public static FederationEntityMetadata parse(String json) throws ParseException {
        return FederationEntityMetadata.parse(JSONObjectUtils.parse(json));
    }
}

