/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.api;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class EntityListingRequest
extends FederationAPIRequest {
    private final EntityType entityType;

    public EntityListingRequest(URI endpoint) {
        this(endpoint, null);
    }

    public EntityListingRequest(URI endpoint, EntityType entityType) {
        super(endpoint);
        this.entityType = entityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.entityType != null) {
            params.put("entity_type", Collections.singletonList(this.entityType.getValue()));
        }
        return Collections.unmodifiableMap(params);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        httpRequest.setQuery(URLUtils.serializeParameters(this.toParameters()));
        return httpRequest;
    }

    public static EntityListingRequest parse(HTTPRequest httpRequest) throws ParseException {
        Map<String, List<String>> params;
        String value;
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        EntityType entityType = null;
        if (ContentType.APPLICATION_URLENCODED.equals((Object)httpRequest.getEntityContentType()) && StringUtils.isNotBlank(value = MultivaluedMapUtils.getFirstValue(params = httpRequest.getQueryParameters(), "entity_type"))) {
            entityType = new EntityType(value);
        }
        return new EntityListingRequest(httpRequest.getURI(), entityType);
    }
}

