/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.ResourceUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class TokenRequest
extends AbstractOptionallyIdentifiedRequest {
    private final AuthorizationGrant authzGrant;
    private final Scope scope;
    private final List<AuthorizationDetail> authorizationDetails;
    private final List<URI> resources;
    private final RefreshToken existingGrant;
    private final Map<String, List<String>> customParams;
    private static final Set<String> ALLOWED_REPEATED_PARAMS = new HashSet<String>(Arrays.asList("resource", "audience"));

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, clientAuth, authzGrant, scope, null, null);
    }

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope, List<URI> resources, Map<String, List<String>> customParams) {
        this(uri, clientAuth, authzGrant, scope, null, resources, customParams);
    }

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope, List<AuthorizationDetail> authorizationDetails, List<URI> resources, Map<String, List<String>> customParams) {
        super(uri, clientAuth);
        if (clientAuth == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
        if (resources != null) {
            for (URI resourceURI : resources) {
                if (ResourceUtils.isLegalResourceURI(resourceURI)) continue;
                throw new IllegalArgumentException("Resource URI must be absolute and with no query or fragment: " + resourceURI);
            }
        }
        this.authorizationDetails = authorizationDetails;
        this.resources = resources;
        this.existingGrant = null;
        this.customParams = MapUtils.isNotEmpty(customParams) ? customParams : Collections.emptyMap();
    }

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant) {
        this(uri, clientAuth, authzGrant, null);
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, clientID, authzGrant, scope, null, null, null);
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope, List<URI> resources, RefreshToken existingGrant, Map<String, List<String>> customParams) {
        this(uri, clientID, authzGrant, scope, null, resources, existingGrant, customParams);
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope, List<AuthorizationDetail> authorizationDetails, List<URI> resources, RefreshToken existingGrant, Map<String, List<String>> customParams) {
        super(uri, clientID);
        if (authzGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires client authentication");
        }
        if (authzGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
        this.authorizationDetails = authorizationDetails;
        if (resources != null) {
            for (URI resourceURI : resources) {
                if (ResourceUtils.isLegalResourceURI(resourceURI)) continue;
                throw new IllegalArgumentException("Resource URI must be absolute and with no query or fragment: " + resourceURI);
            }
        }
        this.resources = resources;
        this.existingGrant = existingGrant;
        this.customParams = MapUtils.isNotEmpty(customParams) ? customParams : Collections.emptyMap();
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant) {
        this(uri, clientID, authzGrant, null);
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, (ClientID)null, authzGrant, scope);
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant) {
        this(uri, (ClientID)null, authzGrant, null);
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public List<URI> getResources() {
        return this.resources;
    }

    public RefreshToken getExistingGrant() {
        return this.existingGrant;
    }

    public Map<String, List<String>> getCustomParameters() {
        return Collections.unmodifiableMap(this.customParams);
    }

    public List<String> getCustomParameter(String name) {
        return this.customParams.get(name);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        LinkedHashMap<String, List<String>> params;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        try {
            params = new LinkedHashMap<String, List<String>>(httpRequest.getBodyAsFormParameters());
        }
        catch (ParseException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        params.putAll(this.authzGrant.toParameters());
        if (this.scope != null && !this.scope.isEmpty()) {
            params.put("scope", Collections.singletonList(this.scope.toString()));
        }
        if (this.getClientID() != null) {
            params.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (this.getAuthorizationDetails() != null) {
            params.put("authorization_details", Collections.singletonList(AuthorizationDetail.toJSONString(this.getAuthorizationDetails())));
        }
        if (this.getResources() != null) {
            LinkedList<String> values = new LinkedList<String>();
            for (URI uri : this.resources) {
                if (uri == null) continue;
                values.add(uri.toString());
            }
            params.put("resource", values);
        }
        if (this.getExistingGrant() != null) {
            params.put("existing_grant", Collections.singletonList(this.existingGrant.getValue()));
        }
        if (!this.getCustomParameters().isEmpty()) {
            params.putAll(this.getCustomParameters());
        }
        httpRequest.setBody(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        String rt;
        ClientAuthentication clientAuth;
        URI uri = httpRequest.getURI();
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        try {
            clientAuth = ClientAuthentication.parse(httpRequest);
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + e.getMessage()));
        }
        Map params = httpRequest.getBodyAsFormParameters();
        Set<String> repeatParams = MultivaluedMapUtils.getKeysWithMoreThanOneValue(params, ALLOWED_REPEATED_PARAMS);
        if (!repeatParams.isEmpty()) {
            String msg = "Parameter(s) present more than once: " + repeatParams;
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.setDescription(msg));
        }
        if (clientAuth instanceof ClientSecretBasic && (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_assertion")) || StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(params, "client_assertion_type")))) {
            String msg = "Multiple conflicting client authentication methods found: Basic and JWT assertion";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        AuthorizationGrant grant = AuthorizationGrant.parse(params);
        if (clientAuth == null && grant.getType().requiresClientAuthentication()) {
            String msg = "Missing client authentication";
            throw new ParseException(msg, OAuth2Error.INVALID_CLIENT.appendDescription(": " + msg));
        }
        ClientID clientID = null;
        if (clientAuth == null) {
            String clientIDString = (String)MultivaluedMapUtils.getFirstValue(params, "client_id");
            if (clientIDString != null && !clientIDString.trim().isEmpty()) {
                clientID = new ClientID(clientIDString);
            }
            if (clientID == null && grant.getType().requiresClientID()) {
                String msg = "Missing required client_id parameter";
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
        }
        String scopeValue = (String)MultivaluedMapUtils.getFirstValue(params, "scope");
        Scope scope = null;
        if (scopeValue != null) {
            scope = Scope.parse(scopeValue);
        }
        String json = (String)MultivaluedMapUtils.getFirstValue(params, "authorization_details");
        List<AuthorizationDetail> authorizationDetails = null;
        if (json != null) {
            authorizationDetails = AuthorizationDetail.parseList(json);
        }
        LinkedList<URI> resources = null;
        List vList = (List)params.get("resource");
        if (vList != null) {
            resources = new LinkedList<URI>();
            for (String uriValue : vList) {
                URI resourceURI;
                if (uriValue == null) continue;
                String errMsg = "Illegal resource parameter: Must be an absolute URI without a fragment: " + uriValue;
                try {
                    resourceURI = new URI(uriValue);
                }
                catch (URISyntaxException e) {
                    throw new ParseException(errMsg, OAuth2Error.INVALID_TARGET.setDescription(errMsg));
                }
                if (!ResourceUtils.isLegalResourceURI(resourceURI)) {
                    throw new ParseException(errMsg, OAuth2Error.INVALID_TARGET.setDescription(errMsg));
                }
                resources.add(resourceURI);
            }
        }
        RefreshToken existingGrant = StringUtils.isNotBlank(rt = (String)MultivaluedMapUtils.getFirstValue(params, "existing_grant")) ? new RefreshToken(rt) : null;
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>();
        for (Map.Entry p : params.entrySet()) {
            if (((String)p.getKey()).equalsIgnoreCase("grant_type") || ((String)p.getKey()).equalsIgnoreCase("client_id") || ((String)p.getKey()).equalsIgnoreCase("client_secret") || ((String)p.getKey()).equalsIgnoreCase("client_assertion_type") || ((String)p.getKey()).equalsIgnoreCase("client_assertion") || ((String)p.getKey()).equalsIgnoreCase("scope") || ((String)p.getKey()).equalsIgnoreCase("authorization_details") || ((String)p.getKey()).equalsIgnoreCase("resource") || ((String)p.getKey()).equalsIgnoreCase("existing_grant") || grant.getType().getRequestParameterNames().contains(p.getKey())) continue;
            customParams.put((String)p.getKey(), (List<String>)p.getValue());
        }
        if (clientAuth != null) {
            return new TokenRequest(uri, clientAuth, grant, scope, authorizationDetails, resources, customParams);
        }
        return new TokenRequest(uri, clientID, grant, scope, authorizationDetails, resources, existingGrant, customParams);
    }
}

