/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class UserInfoSuccessResponse
extends UserInfoResponse
implements SuccessResponse {
    private final UserInfo claimsSet;
    private final JWT jwt;

    public UserInfoSuccessResponse(UserInfo claimsSet) {
        this.claimsSet = Objects.requireNonNull(claimsSet);
        this.jwt = null;
    }

    public UserInfoSuccessResponse(JWT jwt) {
        this.jwt = Objects.requireNonNull(jwt);
        this.claimsSet = null;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ContentType getEntityContentType() {
        if (this.claimsSet != null) {
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.APPLICATION_JWT;
    }

    public UserInfo getUserInfo() {
        return this.claimsSet;
    }

    public JWT getUserInfoJWT() {
        return this.jwt;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        String content;
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(this.getEntityContentType());
        if (this.claimsSet != null) {
            content = this.claimsSet.toJSONObject().toString();
        } else {
            try {
                content = this.jwt.serialize();
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize UserInfo claims JWT: " + e.getMessage(), e);
            }
        }
        httpResponse.setBody(content);
        return httpResponse;
    }

    public static UserInfoSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        UserInfoSuccessResponse response;
        httpResponse.ensureStatusCode(200);
        httpResponse.ensureEntityContentType();
        ContentType ct = httpResponse.getEntityContentType();
        if (ct.matches(ContentType.APPLICATION_JSON)) {
            UserInfo claimsSet;
            try {
                claimsSet = new UserInfo(httpResponse.getBodyAsJSONObject());
            }
            catch (Exception e) {
                throw new ParseException("Couldn't parse UserInfo claims: " + e.getMessage(), e);
            }
            response = new UserInfoSuccessResponse(claimsSet);
        } else if (ct.matches(ContentType.APPLICATION_JWT)) {
            JWT jwt;
            try {
                jwt = httpResponse.getBodyAsJWT();
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse UserInfo claims JWT: " + e.getMessage(), e);
            }
            response = new UserInfoSuccessResponse(jwt);
        } else {
            throw new ParseException("Unexpected Content-Type, must be " + String.valueOf(ContentType.APPLICATION_JSON) + " or " + String.valueOf(ContentType.APPLICATION_JWT));
        }
        return response;
    }
}

