/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.assertions.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import com.nimbusds.oauth2.sdk.auth.Secret;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JWTAssertionFactory {
    public static Set<JWSAlgorithm> supportedJWAs() {
        HashSet supported = new HashSet();
        supported.addAll(JWSAlgorithm.Family.HMAC_SHA);
        supported.addAll(JWSAlgorithm.Family.RSA);
        supported.addAll(JWSAlgorithm.Family.EC);
        return Collections.unmodifiableSet(supported);
    }

    public static SignedJWT create(JWTAssertionDetails details, JWSAlgorithm jwsAlgorithm, Secret secret) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(jwsAlgorithm), details.toJWTClaimsSet());
        signedJWT.sign((JWSSigner)new MACSigner(secret.getValueBytes()));
        return signedJWT;
    }

    public static SignedJWT create(JWTAssertionDetails details, JWSAlgorithm jwsAlgorithm, PrivateKey privateKey, String keyID, List<Base64> x5c, Base64URL x5t256, Provider jcaProvider) throws JOSEException {
        RSASSASigner signer;
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(jwsAlgorithm).keyID(keyID).x509CertChain(x5c).x509CertSHA256Thumbprint(x5t256).build(), details.toJWTClaimsSet());
        if (RSASSASigner.SUPPORTED_ALGORITHMS.contains(jwsAlgorithm)) {
            signer = new RSASSASigner(privateKey);
        } else if (ECDSASigner.SUPPORTED_ALGORITHMS.contains(jwsAlgorithm)) {
            Set curves = Curve.forJWSAlgorithm((JWSAlgorithm)jwsAlgorithm);
            if (curves.size() != 1) {
                throw new JOSEException("Couldn't determine curve for JWS algorithm: " + String.valueOf(jwsAlgorithm));
            }
            signer = new ECDSASigner(privateKey, (Curve)curves.iterator().next());
        } else {
            throw new JOSEException("Unsupported JWS algorithm: " + String.valueOf(jwsAlgorithm));
        }
        if (jcaProvider != null) {
            signer.getJCAContext().setProvider(jcaProvider);
        }
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    @Deprecated
    public static SignedJWT create(JWTAssertionDetails details, JWSAlgorithm jwsAlgorithm, RSAPrivateKey rsaPrivateKey, String keyID, Provider jcaProvider) throws JOSEException {
        return JWTAssertionFactory.create(details, jwsAlgorithm, rsaPrivateKey, keyID, null, null, jcaProvider);
    }

    @Deprecated
    public static SignedJWT create(JWTAssertionDetails details, JWSAlgorithm jwsAlgorithm, ECPrivateKey ecPrivateKey, String keyID, Provider jcaProvider) throws JOSEException {
        return JWTAssertionFactory.create(details, jwsAlgorithm, ecPrivateKey, keyID, null, null, jcaProvider);
    }

    private JWTAssertionFactory() {
    }
}

