/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.assertions.jwt;

import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class JWTAssertionDetailsVerifier
extends DefaultJWTClaimsVerifier {
    private final Set<Audience> expectedAudience;

    public JWTAssertionDetailsVerifier(Set<Audience> expectedAudience) {
        super(new HashSet<String>(Identifier.toStringList(expectedAudience)), null, new HashSet<String>(Arrays.asList("aud", "exp", "sub", "iss")), null);
        if (CollectionUtils.isEmpty(expectedAudience)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = expectedAudience;
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }
}

