/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.util.HashSet;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ResponseTypeSet
extends HashSet<ResponseType> {
    public static ResponseTypeSet parse(String s) throws ParseException {
        String[] tokens;
        if (StringUtils.isUndefined(s)) {
            throw new ParseException("Null or empty response type set string");
        }
        ResponseTypeSet set = new ResponseTypeSet();
        for (String t : tokens = s.split("\\s+")) {
            set.add(new ResponseType(t));
        }
        return set;
    }

    public boolean impliesCodeFlow() {
        return this.contains(ResponseType.CODE);
    }

    public boolean impliesImplicitFlow() {
        return !this.contains(ResponseType.CODE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ResponseType rt : this) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(rt.getValue());
        }
        return sb.toString();
    }
}

