/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.util.Date;
import org.apache.commons.lang3.RandomStringUtils;

public class Secret {
    private String value;
    private final Date expDate;

    public Secret(String value) {
        this(value, null);
    }

    public Secret(String value, Date expDate) {
        if (StringUtils.isUndefined(value)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = value;
        this.expDate = expDate;
    }

    public Secret(int length) {
        this(RandomStringUtils.randomAlphanumeric((int)length));
    }

    public Secret() {
        this(32);
    }

    public String getValue() {
        return this.value;
    }

    public void erase() {
        this.value = null;
    }

    public Date getExpirationDate() {
        return this.expDate;
    }

    public boolean expired() {
        if (this.expDate == null) {
            return false;
        }
        Date now = new Date();
        return !this.expDate.after(now);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Secret && this.getValue().equals(((Secret)object).getValue());
    }
}

