/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public abstract class ClaimsRequest {
    protected Set<String> requiredClaims = new HashSet<String>();
    protected JSONObject requestedClaims = new JSONObject();

    protected ClaimsRequest() {
    }

    public Set<String> getRequiredClaims() {
        return Collections.unmodifiableSet(this.requiredClaims);
    }

    public JSONObject getRequestedClaimsObject() {
        return this.requestedClaims;
    }

    public Set<String> getRequestedEssentialClaims() {
        HashSet essentialClaims = new HashSet();
        for (Map.Entry claim : this.requestedClaims.entrySet()) {
            boolean claimIsEssential;
            JSONObject claimDetails;
            Object value = claim.getValue();
            if (value == null || !(value instanceof JSONObject) || (claimDetails = (JSONObject)value).get((Object)"essential") == null || !(claimDetails.get((Object)"essential") instanceof Boolean) || !(claimIsEssential = ((Boolean)claimDetails.get((Object)"essential")).booleanValue())) continue;
            essentialClaims.add(claim.getKey());
        }
        return Collections.unmodifiableSet(essentialClaims);
    }

    public Set<String> getRequestedVoluntaryClaims() {
        HashSet voluntaryClaims = new HashSet();
        for (Map.Entry claim : this.requestedClaims.entrySet()) {
            Object value = claim.getValue();
            if (value == null || !(value instanceof JSONObject)) {
                voluntaryClaims.add(claim.getKey());
                continue;
            }
            JSONObject claimDetails = (JSONObject)value;
            if (claimDetails.get((Object)"essential") == null || !(claimDetails.get((Object)"essential") instanceof Boolean)) {
                voluntaryClaims.add(claim.getKey());
                continue;
            }
            boolean claimIsEssential = (Boolean)claimDetails.get((Object)"essential");
            if (claimIsEssential) continue;
            voluntaryClaims.add(claim.getKey());
        }
        return Collections.unmodifiableSet(voluntaryClaims);
    }

    public Set<String> getClaimNames() {
        return Collections.unmodifiableSet(this.requestedClaims.keySet());
    }
}

